/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions.soap.adapter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * This is an adapter used when integrating with JBossWS.
 *  
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class SOAPProcessorHttpServletRequest implements HttpServletRequest
{
    private final Map<String, List<String>> headers ;
    
    private final byte[] content ;
    
    private final String path ;
    
    public SOAPProcessorHttpServletRequest(final String path, final byte[] content, final Map<String, List<String>> headers)
    {
        this.path = path ;
        this.content = content ;
        this.headers = headers ;
    }

    public String getHeader(final String name)
    {
        final List<String> values = headers.get(name) ;
        if (values != null)
        {
            return values.get(0) ;
        }
        return null ;
    }

    public Enumeration getHeaderNames()
    {
        return Collections.enumeration(headers.keySet()) ;
    }

    public String getMethod()
    {
        // always use POST
        return "POST" ;
    }

    public String getPathInfo()
    {
        return null ;
    }

    public String getQueryString()
    {
        return null ;
    }

    public String getRequestURI()
    {
        return (path == null ? "/" : path) ;
    }
    
    public String getContextPath()
    {
        return "" ;
    }

    public HttpSession getSession(boolean arg0)
    {
        return null ;
    }

    public String getContentType()
    {
        return getHeader("Content-Type") ;
    }

    public ServletInputStream getInputStream() throws IOException
    {
        return new SOAPProcessorServletInputStream(new ByteArrayInputStream(content)) ;
    }

    public String getParameter(final String name)
    {
        return null ;
    }

    public Principal getUserPrincipal()
    {
        // TODO link this is with security
        return null ;
    }

    public boolean isUserInRole(final String name)
    {
        // TODO link this is with security
        return false ;
    }
    
    public String getAuthType()
    {
        return null;
    }

    public Cookie[] getCookies()
    {
        return null;
    }

    public long getDateHeader(String name)
    {
        String s = this.getHeader(name);
        return s != null ? Long.valueOf(s) : 0;
    }

    public Enumeration getHeaders(final String name)
    {
        final List<String> values = headers.get(name) ;
        if (values != null)
        {
            return Collections.enumeration(values) ;
        }
        else
        {
            return null ;
        }
    }

    public int getIntHeader(String name)
    {
        String s = this.getHeader(name);
        return s != null ? Integer.valueOf(s) : 0;
    }

    /*
     * The following methods are not supported by this adapter.
     */

    public StringBuffer getRequestURL()
    {
        return null;
    }

    public String getPathTranslated()
    {
        return null;
    }

    public String getRemoteUser()
    {
        return null;
    }

    public String getRequestedSessionId()
    {
        return null;
    }

    public String getServletPath()
    {
        return null;
    }

    public HttpSession getSession()
    {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie()
    {
        return false;
    }

    public boolean isRequestedSessionIdFromURL()
    {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl()
    {
        return false;
    }

    public boolean isRequestedSessionIdValid()
    {
        return false;
    }

    public Enumeration getAttributeNames()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getCharacterEncoding()
    {
        return null ;
    }

    public int getContentLength()
    {
        return 0;
    }

    public Locale getLocale()
    {
        return null;
    }

    public Enumeration getLocales()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public Map getParameterMap()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public Enumeration getParameterNames()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String[] getParameterValues(String arg0)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getProtocol()
    {
        return null;
    }

    public BufferedReader getReader() throws IOException
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getRealPath(String arg0)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getRemoteAddr()
    {
        return null;
    }

    public String getRemoteHost()
    {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String arg0)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getScheme()
    {
        return null;
    }

    public String getServerName()
    {
        return null;
    }

    public int getServerPort()
    {
        return 0;
    }

    public boolean isSecure()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public void removeAttribute(String arg0)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public void setAttribute(String arg0, Object arg1)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public void setCharacterEncoding(String arg0)
            throws UnsupportedEncodingException
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public Object getAttribute(String arg0)
    {
        return null ;
//        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getLocalAddr()
    {
        return null;
    }

    public String getLocalName()
    {
        return null;
    }

    public int getLocalPort()
    {
        return 0;
    }

    public int getRemotePort()
    {
        return 0;
    }
}
