/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.registry.systinet;

import java.util.TreeSet;

import org.apache.juddi.IRegistry;
import org.apache.juddi.error.FatalErrorException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import javax.xml.soap.SOAPMessage;
import org.systinet.uddi.client.v2.struct.*;

import java.util.Hashtable;

/**
 * PublishService takes a request and calls the RequestHandler to execute the UDDI call 
 * 
 * @author Tom Cunningham (tcunning@redhat.com)
 */
public class PublishService
{  
  public RequestUtil util;
  public Hashtable operations;
  
  public PublishService() {
	super();
	util = RequestUtil.getInstance();
	operations = util.getPublishQueries();
  }

  public void validateRequest(String operation,String version,Element uddiReq)
		throws RegistryException
	{
    // If the value 
  	// specified is not "2.0" then throw an exception (this 
  	// value must be specified for all UDDI requests and 
  	// only version 2.0 UDDI requests are supported by 
  	// this endpoint).

  	if (version == null)
      throw new FatalErrorException("A UDDI generic attribute " +
        "value was not found for UDDI request: "+operation+" (The " +
        "'generic' attribute must be present)");
    else if (!version.equals(IRegistry.UDDI_V2_GENERIC))
      throw new UnsupportedException("Only UDDI v2 " +
        "requests are currently supported. The generic attribute value " +
        "received was: "+version);

    if ((operation == null) || (operation.trim().length() == 0))
      throw new FatalErrorException("The UDDI service operation " +
        "could not be identified.");
  }
  
  public Node publish(Element uddiReq) throws Exception
  {
	  RequestHandler requestHandler = new RequestHandler();

	  requestHandler.setUddiReq(uddiReq);
      String operation = requestHandler.getOperation(uddiReq);
      String version   = requestHandler.getVersion(uddiReq, operation);
      validateRequest(operation, version, uddiReq);
      Thread thread = new Thread(requestHandler, "WorkThread");
      thread.start();
      thread.join();
      if (requestHandler.getException()!=null) {
          throw new Exception(requestHandler.getException());
      }
      return requestHandler.getResponse();
  }
}
