package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;
import org.jboss.soa.esb.samples.quickstart.webservice_proxy_basic.test.SendWSMessage;

import java.io.InputStream;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jboss.internal.soa.esb.util.StreamUtils;

public class WebServiceProxyBasicTest extends AbstractQuickstartTestCase {
    public static final String SOAP_PRE =
        "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:hello=\"http://webservice_proxy_basic/helloworld\">" +
                "<soapenv:Header/>" +
                "<soapenv:Body>" +
                        "<hello:sayHello>" +
                                "<toWhom>";

    public static final String SOAP_POST =
                                "</toWhom>" +
                        "</hello:sayHello>" +
                "</soapenv:Body>" +
        "</soapenv:Envelope>";


	
	public WebServiceProxyBasicTest(String name) {
		super(name);
	}
	
	public void testWS() throws Exception {
		clearMessages();
		SendWSMessage ws = new SendWSMessage();
		String url = "http://localhost:8080/Quickstart_webservice_proxy_basic_ws/HelloWorldWS";
		
		PostMethod method = new PostMethod(url);
        method.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");

        // this line should be used for better performance/interop but is not necessary
        // http://www.w3.org/TR/2000/NOTE-SOAP-20000508/#_Toc478383528
        // http://www.ws-i.org/Profiles/BasicProfile-1.1.html#SOAPAction_HTTP_Header
        method.setRequestHeader("SOAPAction", "\"\"");

        String request = SOAP_PRE + "jbossesb" + SOAP_POST;
        System.out.println("****  REQUEST BODY: " + request);
        method.setRequestEntity( new StringRequestEntity(request) );

        HttpClient client = new HttpClient();
        InputStream response = null;
        try
        {
                int code = client.executeMethod(method);
                System.out.println("**** RESPONSE CODE: " + code);

                response = method.getResponseBodyAsStream();
                byte[] bytes = StreamUtils.readStream(response);
                System.out.println("**** RESPONSE BODY: " + new String(bytes, method.getResponseCharSet()));
        }
        finally
        {
                method.releaseConnection();
                if (response != null)
                {
                        response.close();
                }
        }

	}

	public static Test suite() throws Exception {
		return getDeploySetup(WebServiceProxyBasicTest.class, "QuickstartMessageStoreServer.sar, Quickstart_webservice_proxy_basic_ws.war, Quickstart_webservice_proxy_basic.esb");
	}	
}
