/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.db;

import javax.management.ObjectName;

import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceMBean;

/**
 * MBean interface.
 * 
 * In all cases we run h2 in the same VM with JBoss.
 * A few notes on h2 running modes:
 * 
 * remote (server) mode
 * 	  h2 can be connected to vid tcp
 * 
 * in-process (standalone) mode
 *    h2 can only be contacted from in-vm clients
 * 
 * memory-only mode
 *    h2 will only keep tables in memory, no persistence of data
 * 
 * @version $Revision: 27106 $
 */
public interface H2DatabaseMBean extends ServiceMBean
{
   /** The default ObjectName */
   ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss:service=h2");

   // Attributes ----------------------------------------------------

   /** The database name, default is 'default' */
   String getDatabase();   
   void setDatabase(String name);

   /** The default user to use when connecting to the DB, default is "sa" */
   String getUser();   
   void setUser(String user);
   
   /** The default password to use when connecting to the DB, default is "" */
   String getPassword();
   void setPassword(String password);
   
   /** The full database path */
   String getDatabasePath();
   
   /** In memory mode */
   boolean isInMemoryMode() ;
   void setInMemoryMode(boolean b) ;
   
   /** Server/remote mode */
   boolean isServerMode() ;
   void setServerMode(boolean mode) ;
   
   /** The flags to use when connecting to the DB, default is "" */
   String getFlags();
   void setFlags(String flags);
   
   /** The listening port when in remove server mode, default is '9092' */
   int getPort();
   void setPort(int port);

   /** The binding address, default is '0.0.0.0' */
   String getBindAddress();
   void setBindAddress(String address);
   
   /** Set the dir that will be used by the database. */
   void setDataDir(final String datadir);
}
