/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.jboss.soa.dsp.ws.DeploymentBuilder;

/**
 * This build processor implementation sets the JAXWS web service provider class
 * name in the JBossWS CXF configuration file, in one has been defined.
 *
 */
public class JBossWSCXFBuildProcessor implements org.jboss.soa.dsp.ws.BuildProcessor {

	private javax.xml.ws.Provider<?> provider;
	
	public JBossWSCXFBuildProcessor(javax.xml.ws.Provider<?> provider) {
		this.provider = provider;
	}
	
	public void process(DeploymentBuilder builder) {
		  // Check if jbossws-cxf.xml is present, and if so, updated the provider implementation class attribute
		  File f=new File(builder.getWebInf(), "jbossws-cxf.xml");
		  
		  if (f.exists()) {
			  FileInputStream fis=null;
			  FileOutputStream fos=null;
			  
			  try {
				  fis=new FileInputStream(f);
				  
				  byte[] b=new byte[fis.available()];
				  fis.read(b);
				  
				  String str=new String(b);
				  
				  fis.close();
				  fis = null;
				  
				  if (str.indexOf("@provider@") != -1) {
					  fos=new FileOutputStream(f);
					  
					  str = str.replaceAll("@provider@", provider.getClass().getName());
					  
					  fos.write(str.getBytes());
					  
					  fos.flush();
					  fos.close();
					  
					  fos = null;
				  } else {
					  // Report error
					  System.err.println("jbossws-cxf.xml file does not contain @provider@ field");
				  }
				  
			  } catch (IOException e) {
				  throw new RuntimeException("Failed to copy files", e);
			  } finally {
				  try {
					  if (fis != null) fis.close();
				  } catch (IOException e) {
				  }
				  try {
					  if (fos != null) fos.close();
				  } catch (IOException e) {
				  }
			  }
		  }		  
	}
}
