/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.ListMap;
import com.intersys.cache.WrapperMap;
import com.intersys.cache.quick.QuickRelationshipObject;
import com.intersys.classes.ArrayOfObjects;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.RegisteredObject;
import com.intersys.objects.CacheCollectionException;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.StringHolder;
import com.intersys.objects.SystemError;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class RelationshipObject
extends WrapperMap
implements ObjectHandle {
    private static String CACHE_CLASS_NAME = "%Library.RelationshipObject";
    private static final int TYPE_ARRAY_OF_OBJECTS = 1003;
    private static final int TYPE_QUICK = 1005;
    private int mType;
    private Database mDB;
    private List mList;

    public RelationshipObject(CacheObject cacheObject) throws CacheException {
        super(new ArrayOfObjects(cacheObject));
        this.mDB = cacheObject.getDatabase();
        this.mType = 1003;
    }

    public RelationshipObject(List list, Database database) {
        super(new ListMap(list));
        this.mDB = database;
        this.mType = 1005;
        this.mList = list;
    }

    public int getOref() throws ObjectClosedException {
        return this.getProxy().getOref();
    }

    public final Object getZRef() throws CacheException {
        return this.getProxy().getZRef();
    }

    public Database getDatabase() {
        return this.mDB;
    }

    public void _close() throws CacheException {
        this.getHandle()._close();
    }

    public String _className() throws CacheException {
        return this.getHandle()._className();
    }

    public String _className(Boolean bl) throws CacheException {
        return this.getHandle()._className(bl);
    }

    public Integer _isModified() throws CacheException {
        return this.getHandle()._isModified();
    }

    public void _normalizeObject() throws CacheException {
        this.getHandle()._normalizeObject();
    }

    public String _packageName() throws CacheException {
        return this.getHandle()._packageName();
    }

    public void _validateObject(Integer n) throws CacheException {
        this.getHandle()._validateObject(n);
    }

    public void _validateObject() throws CacheException {
        this.getHandle()._validateObject();
    }

    public CacheObject getProxy() {
        switch (this.mType) {
            case 1003: {
                return this.asArrayOfObjects().getProxy();
            }
            case 1005: {
                return new QuickRelationshipObject(null, this.mList);
            }
        }
        throw new CacheCollectionException("Unknown Java Binding type.");
    }

    private ObjectHandle getHandle() throws CacheException {
        switch (this.mType) {
            case 1003: {
                return (ObjectHandle)this.getInternal();
            }
            case 1005: {
                throw new CacheException("Not supporteed in Light mode. Use full Database implementation.");
            }
        }
        throw new SystemError("Unknown Java Binding type.");
    }

    private final ArrayOfObjects asArrayOfObjects() {
        if (this.mType == 1003) {
            return (ArrayOfObjects)this.getInternal();
        }
        throw new CacheCollectionException("Not supported in Light mode. Use full Database implementation.");
    }

    public List asList() throws CacheException {
        if (this.mType == 1005) {
            return this.mList;
        }
        return this.valuesAsList();
    }

    private List getAsList() {
        try {
            return this.asList();
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    public void _relate(RegisteredObject registeredObject) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{registeredObject == null ? new Dataholder(2, null) : new Dataholder(registeredObject.getOref())};
        Dataholder dataholder = this.getProxy().runInstanceMethod("Relate", dataholderArray, 3);
    }

    public void _unRelate(RegisteredObject registeredObject) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{registeredObject == null ? new Dataholder(2, null) : new Dataholder(registeredObject.getOref())};
        Dataholder dataholder = this.getProxy().runInstanceMethod("UnRelate", dataholderArray, 3);
    }

    public void insert(RegisteredObject registeredObject) throws CacheException {
        if (registeredObject == null) {
            throw new NullPointerException();
        }
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(registeredObject)};
        Dataholder dataholder = this.getProxy().runInstanceMethod("Insert", dataholderArray, 0);
        this.getProxy().getDatabase().parseStatus(dataholder);
    }

    public Object get(int n) {
        switch (this.mType) {
            case 1003: {
                return this.get(new Integer(n));
            }
            case 1005: {
                return this.mList.get(n);
            }
        }
        throw new CacheCollectionException("Unknown Java Binding type.");
    }

    public boolean add(Object object) {
        switch (this.mType) {
            case 1003: {
                try {
                    this.insert((RegisteredObject)object);
                }
                catch (CacheException cacheException) {
                    return false;
                }
                return true;
            }
            case 1005: {
                if (this.contains(object)) {
                    return false;
                }
                return this.mList.add(object);
            }
        }
        throw new CacheCollectionException("Unknown Java Binding type.");
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        switch (this.mType) {
            case 1003: {
                try {
                    boolean bl = false;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        this.insert((RegisteredObject)iterator.next());
                        bl = true;
                    }
                    return bl;
                }
                catch (CacheException cacheException) {
                    return false;
                }
            }
            case 1005: {
                return this.mList.addAll(collection);
            }
        }
        throw new CacheCollectionException("Unknown Java Binding type.");
    }

    public String getKeyType() {
        return this.asArrayOfObjects().getKeyType();
    }

    public void setKeyType(String string) {
        this.asArrayOfObjects().setKeyType(string);
    }

    public boolean equals(Object object) {
        Object object2 = this.getInternal();
        if (object2 != null && object2 instanceof ArrayOfObjects) {
            return object2.equals(object);
        }
        return super.equals(object);
    }

    public String toString() {
        return this.getInternal().toString() + ": " + super.toString();
    }

    public Integer _count() throws CacheException {
        return this.asArrayOfObjects()._count();
    }

    public Object _first() throws CacheException {
        return this.asArrayOfObjects()._first();
    }

    public Object _next(Object object) throws CacheException {
        return this.asArrayOfObjects()._next(object);
    }

    public Object _previous(Object object) throws CacheException {
        return this.asArrayOfObjects()._previous(object);
    }

    public Object _getFirst(StringHolder stringHolder) throws CacheException {
        return this.asArrayOfObjects()._getFirst(stringHolder);
    }

    public Object _getNext(StringHolder stringHolder) throws CacheException {
        return this.asArrayOfObjects()._getNext(stringHolder);
    }

    public Object _getPrevious(StringHolder stringHolder) throws CacheException {
        return this.asArrayOfObjects()._getPrevious(stringHolder);
    }

    public Object _removeAt(Object object) throws CacheException {
        return this.asArrayOfObjects()._removeAt(object);
    }

    public Object _find(Object object) throws CacheException {
        return this.asArrayOfObjects()._find(object);
    }

    public Boolean _isDefined(Object object) throws CacheException {
        return this.asArrayOfObjects()._isDefined(object);
    }

    public Object _getAt(String string) throws CacheException {
        return this.asArrayOfObjects()._getAt(string);
    }

    public void _setAt(Object object, Object object2) throws CacheException {
        this.asArrayOfObjects()._setAt(object, object2);
    }

    public void _clear() throws CacheException {
        this.asArrayOfObjects()._clear();
    }

    public Object[] toArray() {
        return this.getAsList().toArray();
    }

    public Object remove(int n) {
        return this.getAsList().remove(n);
    }

    public int indexOf(Object object) {
        return this.getAsList().indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.getAsList().lastIndexOf(object);
    }

    public boolean contains(Object object) {
        return this.getAsList().contains(object);
    }

    public boolean addAll(int n, Collection collection) {
        return this.getAsList().addAll(n, collection);
    }

    public boolean containsAll(Collection collection) {
        return this.getAsList().containsAll(collection);
    }

    public boolean removeAll(Collection collection) {
        return this.getAsList().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.getAsList().retainAll(collection);
    }

    public Iterator iterator() {
        return this.getAsList().iterator();
    }

    public List subList(int n, int n2) {
        return this.getAsList().subList(n, n2);
    }

    public ListIterator listIterator() {
        return this.getAsList().listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.getAsList().listIterator(n);
    }

    public Object set(int n, Object object) {
        return this.getAsList().set(n, object);
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getAsList().toArray(objectArray);
    }

    public static String getCacheClassName() {
        return CACHE_CLASS_NAME;
    }

    protected WrapperMap.ValueListIterator createValueListIterator(int n) {
        return new RelationshipIterator(n);
    }

    private class RelationshipIterator
    extends WrapperMap.ValueListIterator {
        public RelationshipIterator(int n) {
            super(n);
        }

        public void add(Object object) {
            try {
                RelationshipObject.this.insert((RegisteredObject)object);
            }
            catch (CacheException cacheException) {
                throw new CacheCollectionException(cacheException);
            }
        }
    }
}

