/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.tools;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import nu.validator.htmlparser.sax.HtmlSerializer;
import nu.validator.htmlparser.test.SystemErrErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XML2HTML {
    public static void main(String[] args) throws SAXException, ParserConfigurationException, MalformedURLException, IOException, TransformerException {
        OutputStream out;
        InputStream in;
        switch (args.length) {
            case 0: {
                in = System.in;
                out = System.out;
                break;
            }
            case 1: {
                in = new FileInputStream(args[0]);
                out = System.out;
                break;
            }
            case 2: {
                in = new FileInputStream(args[0]);
                out = new FileOutputStream(args[1]);
                break;
            }
            default: {
                System.err.println("Too many arguments. No arguments to use stdin/stdout. One argument to reading from file and write to stdout. Two arguments to read from first file and write to second.");
                System.exit(1);
                return;
            }
        }
        HtmlSerializer serializer = new HtmlSerializer(out);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setErrorHandler((ErrorHandler)new SystemErrErrorHandler());
        parser.setContentHandler(serializer);
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", serializer);
        parser.parse(new InputSource(in));
        out.flush();
        out.close();
    }
}

