/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.CacheObject;
import com.intersys.cache.metadata.AbstractCacheField;
import com.intersys.objects.CacheException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class StreamAccessHelper {
    public static void setStreamValue(AbstractCacheField abstractCacheField, Object object, CacheObject cacheObject) throws CacheException {
        try {
            if (object instanceof Reader) {
                StreamAccessHelper.setReader(abstractCacheField, cacheObject, (Reader)object);
            } else if (object instanceof InputStream) {
                StreamAccessHelper.setBStream(abstractCacheField, cacheObject, (InputStream)object);
            } else if (object instanceof String) {
                abstractCacheField.getWriter(cacheObject).write((String)object);
            } else if (object instanceof byte[]) {
                abstractCacheField.getBStream(cacheObject).write((byte[])object);
            } else if (object instanceof char[]) {
                abstractCacheField.getWriter(cacheObject).write((char[])object);
            }
            return;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read/write property " + abstractCacheField.getDeclaringCacheClass().getName() + "." + abstractCacheField.getName());
        }
    }

    private static void setReader(AbstractCacheField abstractCacheField, CacheObject cacheObject, Reader reader) throws CacheException, IOException {
        char[] cArray;
        int n;
        Writer writer = abstractCacheField.getWriter(cacheObject);
        while (reader.ready() && (n = reader.read(cArray = new char[8192])) >= 0) {
            writer.write(cArray, 0, n);
        }
    }

    private static void setBStream(AbstractCacheField abstractCacheField, CacheObject cacheObject, InputStream inputStream) throws CacheException, IOException {
        int n;
        OutputStream outputStream = abstractCacheField.getBStream(cacheObject);
        int n2 = 8192;
        byte[] byArray = new byte[n2];
        while (inputStream.available() > 0 && (n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }
}

