/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashSet;

public abstract class FileHelper {
    private static final int FAT_PRECISION = 2000;

    public static void synchronize(File source, File destination, boolean smart) throws IOException {
        if (source.isDirectory()) {
            String[] dests;
            if (!destination.exists()) {
                destination.mkdirs();
            } else if (!destination.isDirectory()) {
                throw new IOException("Source and Destination not of the same type:" + source.getCanonicalPath() + " , " + destination.getCanonicalPath());
            }
            String[] sources = source.list();
            HashSet<String> srcNames = new HashSet<String>(Arrays.asList(sources));
            for (String fileName : dests = destination.list()) {
                if (srcNames.contains(fileName)) continue;
                FileHelper.delete(new File(destination, fileName));
            }
            for (String fileName : sources) {
                File srcFile = new File(source, fileName);
                File destFile = new File(destination, fileName);
                FileHelper.synchronize(srcFile, destFile, smart);
            }
        } else {
            if (destination.exists() && destination.isDirectory()) {
                FileHelper.delete(destination);
            }
            if (destination.exists()) {
                long sts = source.lastModified() / 2000L;
                long dts = destination.lastModified() / 2000L;
                if (!smart || sts == 0L || sts != dts || source.length() != destination.length()) {
                    FileHelper.copyFile(source, destination);
                }
            } else {
                FileHelper.copyFile(source, destination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(srcFile);
            FileChannel iChannel = is.getChannel();
            os = new FileOutputStream(destFile, false);
            FileChannel oChannel = os.getChannel();
            oChannel.transferFrom(iChannel, 0L, srcFile.length());
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        destFile.setLastModified(srcFile.lastModified());
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                FileHelper.delete(subFile);
            }
        }
        if (file.exists()) {
            file.delete();
        }
    }
}

