/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.oldmetadata;

import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheQuery;
import com.intersys.objects.Database;
import com.intersys.objects.InvalidClassException;
import com.intersys.objects.reflect.CacheArgumentInfo;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheQueryDefinition;
import java.sql.SQLException;

public class JDBCCacheQueryInfo
implements CacheQueryDefinition {
    private String mName;
    private String mProcName = null;
    private String mStatement = null;
    private int mNumParam = -1;
    CacheClass mClass = null;
    private SysDatabase mDB;

    protected JDBCCacheQueryInfo(SysDatabase sysDatabase, JDBCAdapter jDBCAdapter, CacheClass cacheClass, String string) throws CacheException {
        this.mDB = sysDatabase;
        this.mClass = cacheClass;
        this.mName = string;
        this.getQueryInfo(jDBCAdapter);
    }

    protected JDBCCacheQueryInfo(SysDatabase sysDatabase, CacheClass cacheClass, String string, String string2, int n) {
        this.mDB = sysDatabase;
        this.mClass = cacheClass;
        this.mName = string;
        this.mNumParam = n;
        this.mProcName = string2;
    }

    public String getName() {
        return this.mName;
    }

    public int getNumberOfParameters() {
        return this.mNumParam;
    }

    public String getStatement() throws CacheException {
        if (this.mStatement == null) {
            this.mStatement = this.makeStatement(this.mNumParam);
        }
        return this.mStatement;
    }

    public String getStatement(int n) throws CacheException {
        if (n > this.mNumParam) {
            throw new CacheException("Invalid number of parameters (" + n + ") for query " + this.getName() + ": maximum allowed are " + this.mNumParam);
        }
        return this.makeStatement(n);
    }

    public CacheClass getDeclaringClass() {
        return this.mClass;
    }

    public CacheQuery prepareQuery() throws CacheException {
        return new CacheQuery((Database)this.mDB, this);
    }

    void getQueryInfo(JDBCAdapter jDBCAdapter) throws CacheException {
        byte[] byArray = jDBCAdapter.getQueryProcInfo(this.mClass.getName(), this.getName());
        if (byArray == null) {
            throw new InvalidClassException(this.getName(), "Query " + this.getName() + " in class " + this.mClass.getName() + " not found in Cache");
        }
        try {
            Object object = SysListProxy.createSysList(byArray, new ConnectionInfo());
            if (this.mDB.getReflectionVersion() > 3) {
                Object object2 = SysListProxy.getWrappedItem(object);
                Dataholder dataholder = new Dataholder(4096, object2);
                this.mDB.parseStatus(dataholder);
            }
            this.mProcName = SysListProxy.getString(object);
            this.mNumParam = SysListProxy.getInteger(object);
        }
        catch (SQLException sQLException) {
            throw new InvalidClassException(this.getName(), "Query " + this.getName() + " in class " + this.mClass.getName() + " has wrong info in Cache");
        }
    }

    private String makeStatement(int n) {
        return Dataholder.makeQueryStatement(this.mProcName, n);
    }

    public String[] getDefaultArgs() {
        throw new UnsupportedOperationException("Method getDefaultArgs() is not implemented in class com.intersys.cache.oldmetadata.JDBCCacheQueryInfo");
    }

    public String getProcName() {
        return this.mProcName;
    }

    public String[] getResultSetColumnNames() {
        throw new UnsupportedOperationException("Method getResultSetColumnNames() is not implemented in class com.intersys.cache.oldmetadata.JDBCCacheQueryInfo");
    }

    public CacheArgumentInfo[] getParameters() throws CacheException {
        throw new UnsupportedOperationException("Method getParameters() is not implemented in class com.intersys.cache.oldmetadata.JDBCCacheQueryInfo");
    }
}

