/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.Dataholder;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheReader;
import com.intersys.objects.CacheWriter;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;

class QuickReaderObject
extends QuickCacheObject {
    private Reader mIS;
    private CharArrayWriter mOS;
    private QuickCacheWriter mOut = null;
    private QuickCacheReader mIn = null;
    private long mNumeberOfReadChars;
    private boolean mUnchanged;

    public QuickReaderObject(TableBasedClass tableBasedClass, Reader reader, CharArrayWriter charArrayWriter) {
        super(tableBasedClass);
        this.mIS = reader;
        this.mOS = charArrayWriter;
        this.mNumeberOfReadChars = -1L;
        this.mUnchanged = true;
    }

    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        return null;
    }

    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
    }

    public Object newJavaInstance() throws CacheException {
        return this.getIn();
    }

    public Object newJavaInstance(boolean bl) throws CacheException {
        return this.newJavaInstance();
    }

    public int save(boolean bl) throws CacheException {
        return 0;
    }

    public CacheReader getIn() throws CacheException {
        if (this.mIn == null) {
            this.mIn = new QuickCacheReader();
        }
        return this.mIn;
    }

    public CacheWriter getOut() throws CacheException {
        if (this.mOut == null) {
            this.mOut = new QuickCacheWriter();
        }
        return this.mOut;
    }

    private void nullifyInput() throws IOException {
        if (this.mIS != null) {
            this.mIS.close();
        }
        this.mIS = null;
    }

    protected Reader getInForSetting() throws CacheException {
        if (this.mUnchanged) {
            return null;
        }
        return this.getIn();
    }

    protected void close() throws CacheException {
        try {
            if (this.mIn != null) {
                this.mIn.close();
            }
            if (this.mOut != null) {
                this.mOut.close();
            }
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to close streams.");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    class QuickCacheReader
    extends CacheReader {
        public QuickCacheReader() {
            super(null);
        }

        public synchronized String read(int n) throws IOException {
            char[] cArray = new char[n];
            this.check();
            int n2 = QuickReaderObject.this.mIS.read(cArray);
            if (QuickReaderObject.this.mNumeberOfReadChars < 0L) {
                QuickReaderObject.this.mNumeberOfReadChars = n2;
            } else {
                QuickReaderObject.this.mNumeberOfReadChars += n2;
            }
            if (n2 > 0) {
                return new String(cArray, 0, n2);
            }
            return "";
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            this.check();
            int n3 = QuickReaderObject.this.mIS.read(cArray, n, n2);
            if (QuickReaderObject.this.mNumeberOfReadChars < 0L) {
                QuickReaderObject.this.mNumeberOfReadChars = n3;
            } else {
                QuickReaderObject.this.mNumeberOfReadChars += n3;
            }
            return n3;
        }

        public boolean ready() throws IOException {
            this.check();
            return QuickReaderObject.this.mIS.ready();
        }

        public boolean markSupported() {
            if (QuickReaderObject.this.mIS == null) {
                return true;
            }
            return QuickReaderObject.this.mIS.markSupported();
        }

        public synchronized void reset() throws IOException {
            if (QuickReaderObject.this.mIS == null) {
                throw new IOException("Either nothing was marked or write occured afterwards");
            }
            QuickReaderObject.this.mIS.reset();
        }

        public synchronized void mark(int n) throws IOException {
            this.check();
            QuickReaderObject.this.mIS.mark(n);
        }

        public void close() throws IOException {
            QuickReaderObject.this.nullifyInput();
        }

        public void rewind() throws CacheException {
            throw new CacheException("Operation is not supported with Light connection");
        }

        public void seek(long l) throws IOException {
            throw new IOException("Operation is not supported with Light connection");
        }

        public synchronized long tell() {
            throw new RuntimeException("Operation is not supported with Light connection");
        }

        private void check() {
            if (QuickReaderObject.this.mIS == null) {
                QuickReaderObject.this.mIS = new CharArrayReader(QuickReaderObject.this.mOS.toCharArray());
            }
        }
    }

    class QuickCacheWriter
    extends CacheWriter {
        public QuickCacheWriter() {
            super(null);
        }

        public void rewind() throws CacheException {
            throw new CacheException("Operation is not supported by Light connection");
        }

        public void write(char[] cArray) throws IOException {
            QuickReaderObject.this.mOS.write(cArray);
            if (cArray.length != 0 || QuickReaderObject.this.mNumeberOfReadChars != 0L) {
                QuickReaderObject.this.mUnchanged = false;
            }
            QuickReaderObject.this.nullifyInput();
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            QuickReaderObject.this.mOS.write(cArray, n, n2);
            if (cArray.length != 0 || QuickReaderObject.this.mNumeberOfReadChars != 0L) {
                QuickReaderObject.this.mUnchanged = false;
            }
            QuickReaderObject.this.nullifyInput();
        }

        public void close() throws IOException {
            if (QuickReaderObject.this.mOS != null) {
                QuickReaderObject.this.mOS.close();
            }
        }

        public void flush() throws IOException {
            QuickReaderObject.this.mOS.flush();
        }
    }
}

