/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.impl.store.access.conglomerate.TemplateRow;

public class OpenConglomerateScratchSpace
implements DynamicCompiledOpenConglomInfo {
    private DataValueDescriptor[] row_for_export_template;
    private DataValueDescriptor[] scratch_template;
    private DataValueDescriptor[] scratch_row;
    private int[] format_ids;
    private int[] collation_ids;
    private RowPosition scratch_row_position;

    public OpenConglomerateScratchSpace(int[] nArray, int[] nArray2) {
        this.format_ids = nArray;
        this.collation_ids = nArray2;
    }

    public DataValueDescriptor[] get_row_for_export(Transaction transaction) throws StandardException {
        if (this.row_for_export_template == null) {
            this.row_for_export_template = RowUtil.newTemplate(transaction.getDataValueFactory(), null, this.format_ids, this.collation_ids);
        }
        return RowUtil.newRowFromTemplate(this.row_for_export_template);
    }

    public DataValueDescriptor[] get_scratch_row(Transaction transaction) throws StandardException {
        if (this.scratch_row == null) {
            this.scratch_row = this.get_row_for_export(transaction);
        }
        return this.scratch_row;
    }

    public DataValueDescriptor[] get_template(Transaction transaction) throws StandardException {
        if (this.scratch_template == null) {
            this.scratch_template = TemplateRow.newRow(transaction, null, this.format_ids, this.collation_ids);
        }
        return this.scratch_template;
    }

    public RowPosition get_scratch_row_position() {
        if (this.scratch_row_position == null) {
            this.scratch_row_position = new RowPosition();
        }
        return this.scratch_row_position;
    }
}

