/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.rte.comm.BasicSocketComm;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.rte.comm.SocketComm;
import com.sap.dbtech.util.MessageTranslator;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;

public class NiCommunication
extends BasicSocketComm {
    private static final String NiHandle_Class_C = "com.sap.ni.NiHandle";
    private static final String NiRoute_Class_C = "com.sap.ni.NiRoute";
    private static final String NiRouteEntry_Class_C = "com.sap.ni.NiRouteEntry";
    private static final String Ni_Class_C = "com.sap.ni.NI";
    private static Class niRoute;
    private static Class niHandle;
    private static Class niRouteEntry;
    private static Class ni;
    public static final JdbcCommFactory factory;
    static /* synthetic */ Class class$java$lang$String;

    public NiCommunication(String string, Properties properties) throws RTEException {
        super(string, properties);
        try {
            niRoute = Class.forName(NiRoute_Class_C);
            niHandle = Class.forName(NiHandle_Class_C);
            niRouteEntry = Class.forName(NiRouteEntry_Class_C);
            ni = Class.forName(Ni_Class_C);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RTEException(MessageTranslator.translate("error.host.niloadlibrary", classNotFoundException.toString()), -709);
        }
        try {
            Constructor constructor = niRoute.getConstructor(class$java$lang$String == null ? (class$java$lang$String = NiCommunication.class$("java.lang.String")) : class$java$lang$String);
            Object t = constructor.newInstance(string);
            Vector vector = (Vector)niRoute.getField("route_entries").get(t);
            Object e = vector.lastElement();
            String string2 = (String)e.getClass().getMethod("getPort", new Class[0]).invoke(e, new Object[0]);
            if (string2 == null || string2.equals("") || string2.equals("3299")) {
                this.host = this.host + "/S/" + this.getDefaultPort();
            }
        }
        catch (Exception exception) {
            throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host, exception.toString(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
        this.openSocket();
    }

    protected BasicSocketComm getNewCommunication() throws RTEException {
        return new SocketComm(this.host, null);
    }

    protected void openSocket() throws RTEException {
        try {
            Object object = ni.getField("NI_TALK_NATIVE").get(null);
            Constructor constructor = niHandle.getConstructor(class$java$lang$String == null ? (class$java$lang$String = NiCommunication.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Byte.TYPE);
            Object t = constructor.newInstance(this.host, new Integer(0), object);
            this.socket = (Socket)niHandle.getMethod("getSocket", new Class[0]).invoke(t, new Object[0]);
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host, unknownHostException.toString(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13]);
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host, iOException.toString(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
        catch (Exception exception) {
            throw new RTEException(MessageTranslator.translate("error.host.niconnect", this.host, exception.toString(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
        try {
            this.socket.setSoLinger(true, 15);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected int getDefaultPort() {
        return 7269;
    }

    protected boolean socketMustClosedAfterInfoRequest() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        factory = new JdbcCommFactory(){

            public JdbcCommunication open(String string, String string2, Properties properties) throws RTEException {
                NiCommunication niCommunication = new NiCommunication(string, properties);
                niCommunication.connectDB(string2);
                return niCommunication;
            }

            public JdbcCommunication xopen(String string, String string2, String string3, String string4, Properties properties) throws RTEException {
                NiCommunication niCommunication = new NiCommunication(string, properties);
                niCommunication.connectAdmin(string2, string3, string4);
                return niCommunication;
            }
        };
    }
}

