/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.SetTransactionDescriptor;
import sqlj.runtime.profile.ref.LocalStatement;
import sqlj.runtime.profile.ref.ProfileWrapper;

public class TransactionControlProfile
extends ProfileWrapper {
    private boolean m_handleCommit = true;
    private boolean m_handleRollback = true;
    private boolean m_handleSetTransaction = true;

    public TransactionControlProfile(ConnectedProfile connectedProfile) {
        super(connectedProfile);
    }

    public TransactionControlProfile(ConnectedProfile connectedProfile, boolean bl, boolean bl2, boolean bl3) {
        this(connectedProfile);
        this.m_handleCommit = bl;
        this.m_handleRollback = bl2;
        this.m_handleSetTransaction = bl3;
    }

    public RTStatement getStatement(int n2, BatchContext batchContext, Map map) throws SQLException {
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n2);
        switch (entryInfo.getRole()) {
            case 11: {
                if (!this.m_handleCommit) break;
                this.verifyEntry(entryInfo);
                return new CommitStatement(this.getConnection());
            }
            case 12: {
                if (!this.m_handleRollback) break;
                this.verifyEntry(entryInfo);
                String string = entryInfo.getSQLString().toLowerCase();
                if (string != null && string.indexOf("savepoint") != -1) break;
                return new RollbackStatement(this.getConnection());
            }
            default: {
                SetTransactionDescriptor setTransactionDescriptor;
                if (!this.m_handleSetTransaction || (setTransactionDescriptor = entryInfo.getTransactionDescriptor()) == null) break;
                this.verifyEntry(entryInfo);
                return new SetTransactionStatement(this.getConnection(), setTransactionDescriptor);
            }
        }
        return this.baseProfile.getStatement(n2, batchContext, map);
    }

    private void verifyEntry(EntryInfo entryInfo) throws SQLException {
        if (entryInfo.getStatementType() != 2) {
            ProfileRefErrors.raise_EXPECTED_PREPARED_STATEMENT(entryInfo.getSQLString());
        }
        if (entryInfo.getExecuteType() != 8) {
            ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
        }
        if (entryInfo.getParamCount() != 0) {
            ProfileRefErrors.raise_UNEXPECTED_PARAMS(entryInfo.getSQLString(), 0, entryInfo.getParamCount());
        }
    }

    public static class SetTransactionStatement
    extends LocalStatement {
        private int m_isolation;
        private int m_accessMode;
        private Connection m_conn;

        public SetTransactionStatement(Connection connection, SetTransactionDescriptor setTransactionDescriptor) {
            this.m_conn = connection;
            this.m_isolation = setTransactionDescriptor.getIsolationLevel();
            this.m_accessMode = setTransactionDescriptor.getAccessMode();
        }

        public int executeUpdate() throws SQLException {
            if (this.m_isolation != 0) {
                this.m_conn.setTransactionIsolation(this.m_isolation);
            }
            if (this.m_accessMode != 3) {
                this.m_conn.setReadOnly(this.m_accessMode == 1);
            }
            return 0;
        }
    }

    public static class RollbackStatement
    extends LocalStatement {
        private Connection m_conn;

        public RollbackStatement(Connection connection) {
            this.m_conn = connection;
        }

        public int executeUpdate() throws SQLException {
            this.m_conn.rollback();
            return 0;
        }
    }

    public static class CommitStatement
    extends LocalStatement {
        private Connection m_conn;

        public CommitStatement(Connection connection) {
            this.m_conn = connection;
        }

        public int executeUpdate() throws SQLException {
            this.m_conn.commit();
            return 0;
        }
    }
}

