/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBlob;
import com.intersys.jdbc.CacheClob;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.jdbc.CacheReader;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.Descriptor;
import com.intersys.jdbc.ObjectFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class CacheCallableStatement
extends CachePreparedStatement
implements CallableStatement {
    protected static final int RESULT_SET_TYPE = -51;

    CacheCallableStatement(CacheConnection cacheConnection, String string) throws SQLException {
        super(cacheConnection, 1003, 1007, string, null);
    }

    CacheCallableStatement(CacheConnection cacheConnection, String string, int n, long l) throws SQLException {
        super(cacheConnection, 1003, string, n, l);
    }

    CacheCallableStatement(CacheConnection cacheConnection) throws SQLException {
        super(cacheConnection);
    }

    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        this.setParameterMode(this.getAbsoluteParameterIndex(n));
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.setParameterModeAndScale(this.getAbsoluteParameterIndex(n), n3);
    }

    public boolean wasNull() throws SQLException {
        return this.outputParameterList.wasNull();
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.outputParameterList.getBoolean(this.getListPosition(n));
    }

    public byte getByte(int n) throws SQLException {
        return this.outputParameterList.getOneByte(this.getListPosition(n));
    }

    public short getShort(int n) throws SQLException {
        return this.outputParameterList.getShort(this.getListPosition(n));
    }

    public int getInt(int n) throws SQLException {
        return this.outputParameterList.getInt(this.getListPosition(n));
    }

    public long getLong(int n) throws SQLException {
        return this.outputParameterList.getLong(this.getListPosition(n));
    }

    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public double getDouble(int n) throws SQLException {
        return this.outputParameterList.getDouble((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.outputParameterList.getBigDecimalScale(this.getListPosition(n), n2);
    }

    public String getString(int n) throws SQLException {
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        int n2 = this.getParameterTypeAbsolute(n);
        if (n2 == -1 || n2 == -4) {
            CacheInputStream cacheInputStream = new CacheInputStream(this.connection, string.getBytes(), this.serverCursorNumber, 1);
            if (cacheInputStream == null) {
                return null;
            }
            return cacheInputStream.toUnicodeString();
        }
        return string;
    }

    public byte[] getBytes(int n) throws SQLException {
        int n2 = this.getParameterTypeAbsolute(n);
        if (n2 == -1 || n2 == -4) {
            String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
            if (string == null) {
                return null;
            }
            CacheInputStream cacheInputStream = new CacheInputStream(this.connection, string.getBytes(), this.serverCursorNumber, 1);
            if (cacheInputStream == null) {
                return null;
            }
            return cacheInputStream.toByte();
        }
        return this.outputParameterList.getByte((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
    }

    public Date getDate(int n) throws SQLException {
        return this.outputParameterList.getDate(this.getListPosition(n));
    }

    public Time getTime(int n) throws SQLException {
        return this.outputParameterList.getTime(this.getListPosition(n));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.outputParameterList.getTimestamp(this.getListPosition(n));
    }

    public synchronized Object getObject(int n) throws SQLException {
        Descriptor descriptor = (Descriptor)this.parameters.elementAt(n - 1);
        int n2 = this.getListPosition(n);
        switch (descriptor.type) {
            case 12: {
                return this.outputParameterList.getString(descriptor, n2);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.outputParameterList.getIntegerWrapper(n2);
            }
            case 8: {
                return this.outputParameterList.getDoubleWrapper(descriptor, n2);
            }
            case 2: {
                return this.outputParameterList.getBigDecimal(descriptor, n2);
            }
            case -7: {
                return this.outputParameterList.getBooleanWrapper(n2);
            }
            case 91: {
                return this.outputParameterList.getDate(n2);
            }
            case 92: {
                return this.outputParameterList.getTime(n2);
            }
            case 93: {
                return this.outputParameterList.getTimestamp(n2);
            }
            case -3: 
            case -2: {
                return this.outputParameterList.getByte(n2);
            }
            case -5: {
                return this.outputParameterList.getLongWrapper(n2);
            }
            case -1: {
                return this.getCharacterStream(n);
            }
            case -4: {
                return this.getBinaryStream(n);
            }
            case -51: {
                return this.getResultSet(this.outputParameterList.getString(descriptor, n2));
            }
            case 2002: {
                return this.fetchStruct(this.outputParameterList.getString(descriptor, n2));
            }
        }
        return this.outputParameterList.getString(descriptor, n2);
    }

    protected final synchronized void prepare(String string, int n, long l) throws SQLException {
        this.preparse(string, n, l);
        if (!this.getCachedInfo(this.sqlText)) {
            this.prepareStoredProcedure();
        }
    }

    protected final synchronized void prepare(String string) throws SQLException {
        this.preparse(string);
        if (!this.getCachedInfo(this.sqlText)) {
            this.prepareStoredProcedure();
        }
    }

    private int getListPosition(int n) throws SQLException {
        if (n > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1093", 466);
        }
        if (n == 1 && this.hasReturnValue == 2) {
            if (!this.isOutParameter(0)) {
                throw new SQLException("Invalid parameter number", "S1093", 466);
            }
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        if (this.hasReturnValue == 1) {
            n3 = 1;
            n2 = 1;
        } else {
            --n4;
        }
        while (n3 < this.parameters.size()) {
            int n5 = this.getParameterMode(n3);
            if (n5 < 5) {
                if (n2 == n4) {
                    if (!this.isOutParameter(n3)) {
                        throw new SQLException("Invalid parameter number", "S1093", 466);
                    }
                    return n3;
                }
                ++n2;
            }
            ++n3;
        }
        throw new SQLException("Invalid parameter number " + n, "S1093", 466);
    }

    private int getParameterNumber(String string) throws SQLException {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!string.equalsIgnoreCase(((CacheStatement.Parameter)this.parameters.elementAt((int)i)).name)) continue;
            return i + 1;
        }
        throw new SQLException("No such parameter: " + string, "S1093", 466);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ResultSet getResultSet(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        CacheStatement cacheStatement = new CacheStatement(this.connection, 1003, 1007, null);
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            cacheStatement.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_CACHE_RESULT_SET_OBJECT);
            cacheStatement.output.wire.set(string);
            cacheStatement.output.wire.set(0);
            cacheStatement.output.send(this.connection.messageCount.getCount());
            int n = cacheStatement.input.readHeader(this.serverCursorNumber, 0, 100);
            if (n == 100) {
                cacheStatement.fetchDone = true;
            }
            cacheStatement.columnInfo(cacheStatement.input.wire);
        }
        return new CacheResultSet(cacheStatement, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object fetchStruct(String string) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_STRUCT_OBJECT);
            this.connection.outMessage.wire.set(string);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readHeader(this.serverCursorNumber, 0, 0);
            ObjectFactory objectFactory = this.connection.registerDatabase().getObjectFactory(this.connection);
            return objectFactory.deserialize(this.connection.inMessage.wire);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.outputParameterList.getBigDecimal((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.outputParameterList.getDate(this.getListPosition(n), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.outputParameterList.getTime(this.getListPosition(n), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.outputParameterList.getTimestamp(this.getListPosition(n), calendar);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (n2 == 2002 || n2 == 2001 || n2 == 2000 || n2 == 2006) {
            throw new SQLException("Type not supported: " + n2, "IM001");
        }
        this.registerOutParameter(n, n2);
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Blob getBlob(int n) throws SQLException {
        if (this.getParameterTypeAbsolute(n) != -4) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        CacheBlob cacheBlob = new CacheBlob(this.connection, string.getBytes(), this.serverCursorNumber);
        if (cacheBlob.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheBlob;
    }

    public Clob getClob(int n) throws SQLException {
        if (this.getParameterTypeAbsolute(n) != -1) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        CacheClob cacheClob = new CacheClob(this.connection, string.getBytes(), this.serverCursorNumber);
        if (cacheClob.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheClob;
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(this.getParameterNumber(string), n);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(this.getParameterNumber(string), n, n2);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(this.getParameterNumber(string), n, string2);
    }

    public void setNull(String string, int n) throws SQLException {
        this.setNull(this.getParameterNumber(string), n);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.getParameterNumber(string), n, string2);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.getParameterNumber(string), bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.getParameterNumber(string), by);
    }

    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.getParameterNumber(string), s);
    }

    public void setInt(String string, int n) throws SQLException {
        this.setInt(this.getParameterNumber(string), n);
    }

    public void setLong(String string, long l) throws SQLException {
        this.setLong(this.getParameterNumber(string), l);
    }

    public void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.getParameterNumber(string), f);
    }

    public void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.getParameterNumber(string), d);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.getParameterNumber(string), bigDecimal);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setString(this.getParameterNumber(string), string2);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.getParameterNumber(string), byArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.getParameterNumber(string), date);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.getParameterNumber(string), time);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.getParameterNumber(string), timestamp);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.getParameterNumber(string), inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.getParameterNumber(string), inputStream, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.getParameterNumber(string), object, n, n2);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.getParameterNumber(string), object, n);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.getParameterNumber(string), object);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.getParameterNumber(string), reader, n);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.getParameterNumber(string), date, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.getParameterNumber(string), time, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.getParameterNumber(string), timestamp, calendar);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getParameterNumber(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getParameterNumber(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getParameterNumber(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getParameterNumber(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getParameterNumber(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getParameterNumber(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getParameterNumber(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getParameterNumber(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getParameterNumber(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getParameterNumber(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getParameterNumber(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getParameterNumber(string));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.getParameterNumber(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getParameterNumber(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getParameterNumber(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getParameterNumber(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getParameterNumber(string), calendar);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getParameterNumber(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getParameterNumber(string));
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        CacheInputStream cacheInputStream;
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        int n2 = this.getParameterTypeAbsolute(n);
        switch (n2) {
            case -4: 
            case -1: {
                cacheInputStream = new CacheInputStream(this.connection, string.getBytes(), this.serverCursorNumber, 1);
                break;
            }
            case -3: {
                cacheInputStream = new CacheInputStream(this.getBytes(n), 1, n2, this.input.wire.getMaxFieldSize());
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation", "07006", 7006);
            }
        }
        if (cacheInputStream.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheInputStream;
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        CacheReader cacheReader;
        String string = this.outputParameterList.getString((Descriptor)this.parameters.elementAt(n - 1), this.getListPosition(n));
        if (string == null) {
            return null;
        }
        switch (this.getParameterTypeAbsolute(n)) {
            case -4: 
            case -1: {
                cacheReader = new CacheReader(this.connection, string.getBytes(), this.serverCursorNumber);
                break;
            }
            case -3: 
            case 12: {
                cacheReader = new CacheReader(string);
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation", "07006", 7006);
            }
        }
        if (cacheReader.isNull()) {
            this.input.wire.isNull = true;
            return null;
        }
        return cacheReader;
    }
}

