/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.OgnlValueStack;
import com.opensymphony.xwork2.util.XWorkConverter;

public class XWorkTestCaseHelper {
    public static ConfigurationManager setUp() throws Exception {
        ConfigurationManager configurationManager = new ConfigurationManager();
        OgnlValueStack stack = new OgnlValueStack();
        ActionContext.setContext(new ActionContext(stack.getContext()));
        LocalizedTextUtil.reset();
        XWorkConverter.resetInstance();
        OgnlValueStack.reset();
        ObjectFactory.setObjectFactory(new ObjectFactory());
        return configurationManager;
    }

    public static ConfigurationManager loadConfigurationProviders(ConfigurationManager configurationManager, ConfigurationProvider ... providers) {
        if (configurationManager != null) {
            configurationManager.clearConfigurationProviders();
        } else {
            configurationManager = new ConfigurationManager();
        }
        configurationManager.clearConfigurationProviders();
        for (ConfigurationProvider prov : providers) {
            configurationManager.addConfigurationProvider(prov);
        }
        configurationManager.getConfiguration().reload(configurationManager.getConfigurationProviders());
        Container container = configurationManager.getConfiguration().getContainer();
        ObjectFactory.setObjectFactory(container.getInstance(ObjectFactory.class));
        return configurationManager;
    }

    public static void tearDown(ConfigurationManager configurationManager) throws Exception {
        ObjectFactory.setObjectFactory(null);
        if (configurationManager != null) {
            configurationManager.destroyConfiguration();
            configurationManager = null;
        }
        ActionContext.setContext(null);
    }
}

