package org.keycloak.models;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

public class BrowserSecurityHeadersTest {

    @Test
    public void contentSecurityPolicyBuilderTest() {
        assertEquals("frame-src 'self'; frame-ancestors 'self'; object-src 'none';", ContentSecurityPolicyBuilder.create().build());
        assertEquals("frame-ancestors 'self'; object-src 'none';", ContentSecurityPolicyBuilder.create().frameSrc(null).build());
        assertEquals("frame-src 'self'; object-src 'none';", ContentSecurityPolicyBuilder.create().frameAncestors(null).build());
        assertEquals("frame-src 'custom-frame-src'; frame-ancestors 'custom-frame-ancestors'; object-src 'none';", ContentSecurityPolicyBuilder.create().frameSrc("'custom-frame-src'").frameAncestors("'custom-frame-ancestors'").build());
        assertEquals("frame-src localhost; frame-ancestors 'self'; object-src 'none';", ContentSecurityPolicyBuilder.create().frameSrc("localhost").build());
        assertEquals("frame-src 'self' localhost; frame-ancestors 'self'; object-src 'none';",
                ContentSecurityPolicyBuilder.create().addFrameSrc("localhost").build());
    }

    private void assertParsedDirectives(String directives) {
        assertEquals(directives, ContentSecurityPolicyBuilder.create(directives).build());
    }

    @Test
    public void parseSecurityPolicyBuilderTest() {
        assertParsedDirectives("frame-src 'self'; frame-ancestors 'self'; object-src 'none';");
        assertParsedDirectives("frame-ancestors 'self'; object-src 'none';");
        assertParsedDirectives("frame-src 'self'; object-src 'none';");
        assertParsedDirectives("frame-src 'custom-frame-src'; frame-ancestors 'custom-frame-ancestors'; object-src 'none';");
        assertParsedDirectives("frame-src 'custom-frame-src'; frame-ancestors 'custom-frame-ancestors'; object-src 'none'; style-src 'self';");
        assertParsedDirectives("frame-src 'custom-frame-src'; frame-ancestors 'custom-frame-ancestors'; object-src 'none'; sandbox;");
        assertEquals("frame-src 'custom-frame-src'; sandbox;", ContentSecurityPolicyBuilder.create("frame-src   'custom-frame-src' ; sandbox ;  ").build());
    }

}
