/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.IOException;
import java.util.TreeSet;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import mx4j.tools.adaptor.http.CommandProcessorUtil;
import mx4j.tools.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.tools.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerCommandProcessor
extends HttpCommandProcessorAdaptor {
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        Element root = document.createElement("Server");
        document.appendChild(root);
        String classVariable = in.getVariable("instanceof");
        String queryNames = in.getVariable("querynames");
        TreeSet<ObjectInstance> mbeans = null;
        ObjectName query = null;
        if (queryNames != null) {
            try {
                query = new ObjectName(queryNames);
                mbeans = new TreeSet(CommandProcessorUtil.createObjectInstanceComparator());
                mbeans.addAll(this.server.queryMBeans(query, null));
            }
            catch (MalformedObjectNameException e) {
                Element exceptionElement = document.createElement("Exception");
                exceptionElement.setAttribute("errorMsg", e.getMessage());
                root.appendChild(exceptionElement);
                return document;
            }
        } else {
            mbeans = new TreeSet<ObjectInstance>(CommandProcessorUtil.createObjectInstanceComparator());
            mbeans.addAll(this.server.queryMBeans(null, null));
        }
        for (ObjectInstance instance : mbeans) {
            if (classVariable != null && !classVariable.equals(instance.getClassName())) continue;
            Element mBeanElement = document.createElement("MBean");
            mBeanElement.setAttribute("objectname", instance.getObjectName().toString());
            mBeanElement.setAttribute("classname", instance.getClassName());
            MBeanInfo info = this.server.getMBeanInfo(instance.getObjectName());
            mBeanElement.setAttribute("description", info.getDescription());
            root.appendChild(mBeanElement);
        }
        return document;
    }
}

