/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.MarshalledObject;
import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.remote.JMXServerErrorException;
import javax.management.remote.rmi.RMIConnection;
import javax.security.auth.Subject;
import mx4j.remote.MX4JRemoteUtils;
import mx4j.remote.rmi.RMIConnectionProxy;

public class RMIConnectionSubjectInvoker
extends RMIConnectionProxy {
    private final Subject subject;
    private final AccessControlContext context;
    private Map environment;

    public static RMIConnection newInstance(RMIConnection nested, Subject subject, AccessControlContext context, Map environment) {
        RMIConnectionSubjectInvoker handler = new RMIConnectionSubjectInvoker(nested, subject, context, environment);
        return (RMIConnection)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{RMIConnection.class}, (InvocationHandler)handler);
    }

    private RMIConnectionSubjectInvoker(RMIConnection nested, Subject subject, AccessControlContext context, Map environment) {
        super(nested);
        this.subject = subject;
        this.context = context;
        this.environment = environment;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("fetchNotifications".equals(methodName) || "close".equals(methodName) || "getConnectionId".equals(methodName)) {
            return this.chain(proxy, method, args);
        }
        if ("addNotificationListeners".equals(methodName)) {
            Subject[] delegates = (Subject[])args[args.length - 1];
            if (delegates == null || delegates.length == 0) {
                return this.chain(proxy, method, args);
            }
            if (delegates.length == 1) {
                return this.subjectInvoke(proxy, method, args, delegates[0]);
            }
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (int i = 0; i < delegates.length; ++i) {
                ObjectName name = ((ObjectName[])args[0])[i];
                MarshalledObject filter = ((MarshalledObject[])args[1])[i];
                Subject delegate = delegates[i];
                Object[] newArgs = new Object[]{new ObjectName[]{name}, new MarshalledObject[]{filter}, new Subject[]{delegate}};
                Integer id = ((Integer[])this.subjectInvoke(proxy, method, newArgs, delegate))[0];
                ids.add(id);
            }
            return ids.toArray(new Integer[ids.size()]);
        }
        Subject delegate = (Subject)args[args.length - 1];
        return this.subjectInvoke(proxy, method, args, delegate);
    }

    private Object subjectInvoke(final Object proxy, final Method method, final Object[] args, Subject delegate) throws Exception {
        return MX4JRemoteUtils.subjectInvoke(this.subject, delegate, this.context, this.environment, new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return RMIConnectionSubjectInvoker.this.chain(proxy, method, args);
            }
        });
    }

    private Object chain(Object proxy, Method method, Object[] args) throws Exception {
        try {
            return super.invoke(proxy, method, args);
        }
        catch (Throwable x) {
            if (x instanceof Exception) {
                throw (Exception)x;
            }
            throw new JMXServerErrorException("Error thrown during invocation", (Error)x);
        }
    }
}

