/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.launcher;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import org.apache.commons.launcher.ExitOnErrorThreadGroup;
import org.apache.commons.launcher.ParentListener;

public class ChildMain
extends Thread {
    public static final String APPEND_OUTPUT_PROP_NAME = "org.apache.commons.launcher.appendOutput";
    public static final String DISPLAY_MINIMIZED_WINDOW_PROP_NAME = "org.apache.commons.launcher.displayMinimizedWindow";
    public static final String DISPOSE_MINIMIZED_WINDOW_PROP_NAME = "org.apache.commons.launcher.disposeMinimizedWindow";
    public static final String EXECUTABLE_PROP_NAME = "org.apache.commons.launcher.executableName";
    public static final String HEARTBEAT_FILE_PROP_NAME = "org.apache.commons.launcher.heartbeatFile";
    public static final String MINIMIZED_WINDOW_TITLE_PROP_NAME = "org.apache.commons.launcher.minimizedWindowTitle";
    public static final String MINIMIZED_WINDOW_ICON_PROP_NAME = "org.apache.commons.launcher.minimizedWindowIcon";
    public static final String OUTPUT_FILE_PROP_NAME = "org.apache.commons.launcher.outputFile";
    public static final String WAIT_FOR_CHILD_PROP_NAME = "org.apache.commons.launcher.waitForChild";
    private String[] args = null;
    static /* synthetic */ Class class$org$apache$commons$launcher$ChildMain;

    private ChildMain(ThreadGroup group, String[] args) {
        super(group, (class$org$apache$commons$launcher$ChildMain == null ? (class$org$apache$commons$launcher$ChildMain = ChildMain.class$("org.apache.commons.launcher.ChildMain")) : class$org$apache$commons$launcher$ChildMain).getName());
        this.args = args;
    }

    public static void main(String[] args) {
        ChildMain mainThread = new ChildMain((ThreadGroup)new ExitOnErrorThreadGroup((class$org$apache$commons$launcher$ChildMain == null ? (class$org$apache$commons$launcher$ChildMain = ChildMain.class$("org.apache.commons.launcher.ChildMain")) : class$org$apache$commons$launcher$ChildMain).getName()), args);
        mainThread.start();
    }

    public void run() {
        if (this.args == null || this.args.length == 0) {
            return;
        }
        try {
            String outputPath;
            boolean waitForChild = false;
            if (System.getProperty(WAIT_FOR_CHILD_PROP_NAME) != null) {
                waitForChild = true;
                String heartbeatFile = System.getProperty(HEARTBEAT_FILE_PROP_NAME);
                ParentListener heartbeat = new ParentListener(heartbeatFile);
                heartbeat.setDaemon(true);
                heartbeat.start();
            }
            if ((outputPath = System.getProperty(OUTPUT_FILE_PROP_NAME)) != null) {
                boolean appendOutput = false;
                if (System.getProperty(APPEND_OUTPUT_PROP_NAME) != null) {
                    appendOutput = true;
                }
                PrintStream ps = new PrintStream(new FileOutputStream(outputPath, appendOutput), true);
                System.setOut(ps);
                System.setErr(ps);
            }
            Class<?> mainClass = Class.forName(this.args[0]);
            Class[] paramTypes = new Class[1];
            Object[] paramValues = new Object[1];
            String[] params = new String[this.args.length - 1];
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.args[i + 1];
            }
            paramTypes[0] = params.getClass();
            paramValues[0] = params;
            Frame frame = null;
            boolean displayMinimizedWindow = false;
            if (System.getProperty(DISPLAY_MINIMIZED_WINDOW_PROP_NAME) != null) {
                displayMinimizedWindow = true;
            }
            String osname = System.getProperty("os.name").toLowerCase();
            if (displayMinimizedWindow && osname.indexOf("windows") >= 0) {
                try {
                    Image iconImage;
                    frame = new Frame();
                    String title = System.getProperty(MINIMIZED_WINDOW_TITLE_PROP_NAME);
                    if (title != null) {
                        frame.setTitle(title);
                    }
                    frame.setState(1);
                    String icon = System.getProperty(MINIMIZED_WINDOW_TITLE_PROP_NAME);
                    if (icon != null && (iconImage = Toolkit.getDefaultToolkit().createImage(icon)) != null) {
                        frame.setIconImage(iconImage);
                    }
                    frame.addWindowListener(new ChildWindowAdapter());
                    Rectangle bounds = frame.getGraphicsConfiguration().getBounds();
                    int width = (int)frame.getBounds().getWidth();
                    int height = frame.getInsets().top + frame.getInsets().bottom;
                    int x = (int)bounds.getWidth() - width;
                    int y = (int)bounds.getHeight() - height;
                    frame.setBounds(x, y, width, height);
                    frame.setResizable(false);
                    frame.setVisible(true);
                }
                catch (Exception fe) {
                    // empty catch block
                }
            }
            Method mainMethod = mainClass.getDeclaredMethod("main", paramTypes);
            mainMethod.invoke(null, paramValues);
            if (frame != null && System.getProperty(DISPOSE_MINIMIZED_WINDOW_PROP_NAME) != null) {
                System.exit(0);
            }
        }
        catch (Throwable t) {
            String message = t.getMessage();
            t.printStackTrace();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ChildWindowAdapter
    extends WindowAdapter {
        private ChildWindowAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

