/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class LoadProperties
extends Task {
    private File srcFile = null;
    private String resource = null;
    private Path classpath = null;
    private final Vector filterChains = new Vector();
    private String encoding = null;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$LoadProperties;

    public final void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    /*
     * Loose catch block
     */
    public final void execute() throws BuildException {
        block27: {
            ByteArrayInputStream tis;
            BufferedInputStream bis;
            block25: {
                if (this.srcFile == null && this.resource == null) {
                    throw new BuildException("One of \"srcfile\" or \"resource\" is required.");
                }
                bis = null;
                if (this.srcFile != null) {
                    if (!this.srcFile.exists()) {
                        throw new BuildException("Source file does not exist.");
                    }
                    if (!this.srcFile.isFile()) {
                        throw new BuildException("Source file is not a file.");
                    }
                    try {
                        bis = new BufferedInputStream(new FileInputStream(this.srcFile));
                    }
                    catch (IOException eyeOhEx) {
                        throw new BuildException(eyeOhEx);
                    }
                } else {
                    InputStream is;
                    ClassLoader cL = this.classpath != null ? this.getProject().createClassLoader(this.classpath) : (class$org$apache$tools$ant$taskdefs$LoadProperties == null ? (class$org$apache$tools$ant$taskdefs$LoadProperties = LoadProperties.class$("org.apache.tools.ant.taskdefs.LoadProperties")) : class$org$apache$tools$ant$taskdefs$LoadProperties).getClassLoader();
                    InputStream inputStream = is = cL == null ? ClassLoader.getSystemResourceAsStream(this.resource) : cL.getResourceAsStream(this.resource);
                    if (is != null) {
                        bis = new BufferedInputStream(is);
                    } else {
                        this.log("Unable to find resource " + this.resource, 1);
                        return;
                    }
                }
                Reader instream = null;
                tis = null;
                instream = this.encoding == null ? new InputStreamReader(bis) : new InputStreamReader((InputStream)bis, this.encoding);
                ChainReaderHelper crh = new ChainReaderHelper();
                crh.setPrimaryReader(instream);
                crh.setFilterChains(this.filterChains);
                crh.setProject(this.getProject());
                instream = crh.getAssembledReader();
                String text = crh.readFully(instream);
                if (text == null) break block25;
                if (!text.endsWith("\n")) {
                    text = text + "\n";
                }
                tis = this.encoding == null ? new ByteArrayInputStream(text.getBytes()) : new ByteArrayInputStream(text.getBytes(this.encoding));
                Properties props = new Properties();
                props.load(tis);
                Property propertyTask = (Property)this.getProject().createTask("property");
                propertyTask.setTaskName(this.getTaskName());
                propertyTask.addProperties(props);
            }
            Object var9_12 = null;
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ioex) {
                // empty catch block
            }
            try {
                if (tis != null) {
                    tis.close();
                }
                break block27;
            }
            catch (IOException ioex) {}
            break block27;
            {
                catch (IOException ioe) {
                    String message = "Unable to load file: " + ioe.toString();
                    throw new BuildException(message, ioe, this.getLocation());
                }
                catch (BuildException be) {
                    throw be;
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException ioex) {
                    // empty catch block
                }
                try {
                    if (tis != null) {
                        tis.close();
                    }
                }
                catch (IOException ioex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public final void addFilterChain(FilterChain filter) {
        this.filterChains.addElement(filter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

