/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;

public class PathConvert
extends Task {
    private Path path = null;
    private Reference refid = null;
    private String targetOS = null;
    private boolean targetWindows = false;
    private boolean onWindows = false;
    private boolean setonempty = true;
    private String property = null;
    private Vector prefixMap = new Vector();
    private String pathSep = null;
    private String dirSep = null;
    private Mapper mapper = null;

    public PathConvert() {
        this.onWindows = Os.isFamily("dos");
    }

    public Path createPath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path.createPath();
    }

    public MapEntry createMap() {
        MapEntry entry = new MapEntry();
        this.prefixMap.addElement(entry);
        return entry;
    }

    public void setTargetos(String target) {
        TargetOs to = new TargetOs();
        to.setValue(target);
        this.setTargetos(to);
    }

    public void setTargetos(TargetOs target) {
        this.targetOS = target.getValue();
        this.targetWindows = !this.targetOS.equals("unix") && !this.targetOS.equals("tandem");
    }

    public void setSetonempty(boolean setonempty) {
        this.setonempty = setonempty;
    }

    public void setProperty(String p) {
        this.property = p;
    }

    public void setRefid(Reference r) {
        if (this.path != null) {
            throw this.noChildrenAllowed();
        }
        this.refid = r;
    }

    public void setPathSep(String sep) {
        this.pathSep = sep;
    }

    public void setDirSep(String sep) {
        this.dirSep = sep;
    }

    public boolean isReference() {
        return this.refid != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Path savedPath = this.path;
        String savedPathSep = this.pathSep;
        String savedDirSep = this.dirSep;
        try {
            if (this.isReference()) {
                this.path = new Path(this.getProject()).createPath();
                Object obj = this.refid.getReferencedObject(this.getProject());
                if (obj instanceof Path) {
                    this.path.setRefid(this.refid);
                } else if (obj instanceof FileSet) {
                    this.path.addFileset((FileSet)obj);
                } else if (obj instanceof DirSet) {
                    this.path.addDirset((DirSet)obj);
                } else if (obj instanceof FileList) {
                    this.path.addFilelist((FileList)obj);
                } else {
                    throw new BuildException("'refid' does not refer to a path, fileset, dirset, or filelist.");
                }
            }
            this.validateSetup();
            String fromDirSep = this.onWindows ? "\\" : "/";
            StringBuffer rslt = new StringBuffer();
            String[] elems = this.path.list();
            if (this.mapper != null) {
                FileNameMapper impl = this.mapper.getImplementation();
                ArrayList<String> ret = new ArrayList<String>();
                for (int i = 0; i < elems.length; ++i) {
                    String[] mapped = impl.mapFileName(elems[i]);
                    for (int m = 0; mapped != null && m < mapped.length; ++m) {
                        ret.add(mapped[m]);
                    }
                }
                elems = ret.toArray(new String[0]);
            }
            for (int i = 0; i < elems.length; ++i) {
                String elem = this.mapElement(elems[i]);
                if (i != 0) {
                    rslt.append(this.pathSep);
                }
                StringTokenizer stDirectory = new StringTokenizer(elem, fromDirSep, true);
                while (stDirectory.hasMoreTokens()) {
                    String token = stDirectory.nextToken();
                    rslt.append(fromDirSep.equals(token) ? this.dirSep : token);
                }
            }
            if (this.setonempty || rslt.length() > 0) {
                String value = rslt.toString();
                this.log("Set property " + this.property + " = " + value, 3);
                this.getProject().setNewProperty(this.property, value);
            }
            Object var13_15 = null;
            this.path = savedPath;
            this.dirSep = savedDirSep;
            this.pathSep = savedPathSep;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.path = savedPath;
            this.dirSep = savedDirSep;
            this.pathSep = savedPathSep;
            throw throwable;
        }
    }

    private String mapElement(String elem) {
        int size = this.prefixMap.size();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                MapEntry entry = (MapEntry)this.prefixMap.elementAt(i);
                String newElem = entry.apply(elem);
                if (newElem == elem) continue;
                elem = newElem;
                break;
            }
        }
        return elem;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapper != null) {
            throw new BuildException("Cannot define more than one mapper");
        }
        this.mapper = mapper;
    }

    public void add(FileNameMapper fileNameMapper) {
        Mapper m = new Mapper(this.getProject());
        m.add(fileNameMapper);
        this.addMapper(m);
    }

    private void validateSetup() throws BuildException {
        if (this.path == null) {
            throw new BuildException("You must specify a path to convert");
        }
        if (this.property == null) {
            throw new BuildException("You must specify a property");
        }
        String dsep = File.separator;
        String psep = File.pathSeparator;
        if (this.targetOS != null) {
            psep = this.targetWindows ? ";" : ":";
            String string = dsep = this.targetWindows ? "\\" : "/";
        }
        if (this.pathSep != null) {
            psep = this.pathSep;
        }
        if (this.dirSep != null) {
            dsep = this.dirSep;
        }
        this.pathSep = psep;
        this.dirSep = dsep;
    }

    private BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested <path> elements when using the refid attribute.");
    }

    public static class TargetOs
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"windows", "unix", "netware", "os/2", "tandem"};
        }
    }

    public class MapEntry {
        private String from = null;
        private String to = null;

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String apply(String elem) {
            if (this.from == null || this.to == null) {
                throw new BuildException("Both 'from' and 'to' must be set in a map entry");
            }
            String cmpElem = PathConvert.this.onWindows ? elem.toLowerCase() : elem;
            String cmpFrom = PathConvert.this.onWindows ? this.from.toLowerCase() : this.from;
            return cmpElem.startsWith(cmpFrom) ? this.to + elem.substring(this.from.length()) : elem;
        }
    }
}

