/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ZipScanner
extends DirectoryScanner {
    protected File srcFile;
    private Resource lastScannedResource;
    private Hashtable myentries;
    private String encoding;

    public void setSrc(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String[] getIncludedFiles() {
        if (this.srcFile != null) {
            Vector<String> myvector = new Vector<String>();
            this.scanme();
            Enumeration e = this.myentries.elements();
            while (e.hasMoreElements()) {
                Resource myresource = (Resource)e.nextElement();
                if (myresource.isDirectory() || !this.match(myresource.getName())) continue;
                myvector.addElement(myresource.getName());
            }
            Object[] files = new String[myvector.size()];
            myvector.copyInto(files);
            Arrays.sort(files);
            return files;
        }
        return super.getIncludedFiles();
    }

    public String[] getIncludedDirectories() {
        if (this.srcFile != null) {
            Vector<String> myvector = new Vector<String>();
            this.scanme();
            Enumeration e = this.myentries.elements();
            while (e.hasMoreElements()) {
                Resource myresource = (Resource)e.nextElement();
                if (!myresource.isDirectory() || !this.match(myresource.getName())) continue;
                myvector.addElement(myresource.getName());
            }
            Object[] files = new String[myvector.size()];
            myvector.copyInto(files);
            Arrays.sort(files);
            return files;
        }
        return super.getIncludedDirectories();
    }

    public void init() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    public boolean match(String path) {
        String vpath = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return this.isIncluded(vpath) && !this.isExcluded(vpath);
    }

    public Resource getResource(String name) {
        if (this.srcFile == null) {
            return super.getResource(name);
        }
        if (name.equals("")) {
            return new Resource("", true, Long.MAX_VALUE, true);
        }
        this.scanme();
        if (this.myentries.containsKey(name)) {
            return (Resource)this.myentries.get(name);
        }
        if (this.myentries.containsKey(name + "/")) {
            return (Resource)this.myentries.get(name + "/");
        }
        return new Resource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanme() {
        Resource thisresource;
        block10: {
            thisresource = new Resource(this.srcFile.getAbsolutePath(), this.srcFile.exists(), this.srcFile.lastModified());
            if (this.lastScannedResource != null && this.lastScannedResource.getName().equals(thisresource.getName()) && this.lastScannedResource.getLastModified() == thisresource.getLastModified()) {
                return;
            }
            ZipEntry entry = null;
            ZipFile zf = null;
            this.myentries = new Hashtable();
            try {
                try {
                    zf = new ZipFile(this.srcFile, this.encoding);
                }
                catch (ZipException ex) {
                    throw new BuildException("problem reading " + this.srcFile, ex);
                }
                catch (IOException ex) {
                    throw new BuildException("problem opening " + this.srcFile, ex);
                }
                Enumeration e = zf.getEntries();
                while (e.hasMoreElements()) {
                    entry = (ZipEntry)e.nextElement();
                    this.myentries.put(new String(entry.getName()), new Resource(entry.getName(), true, entry.getTime(), entry.isDirectory(), entry.getSize()));
                }
                Object var6_7 = null;
                if (zf == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (zf == null) throw throwable;
                try {
                    zf.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ex) {}
            zf.close();
        }
        this.lastScannedResource = thisresource;
    }
}

