/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.util.LinkedList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.ParamParent;
import org.apache.taglibs.standard.tag.common.core.Util;

public abstract class ParamSupport
extends BodyTagSupport {
    protected String name;
    protected String value;
    protected boolean encode = true;

    public ParamSupport() {
        this.init();
    }

    private void init() {
        this.value = null;
        this.name = null;
    }

    public int doEndTag() throws JspException {
        Tag tag = ParamSupport.findAncestorWithClass((Tag)this, (Class)ParamParent.class);
        if (tag == null) {
            throw new JspTagException(Resources.getMessage("PARAM_OUTSIDE_PARENT"));
        }
        if (this.name == null || this.name.equals("")) {
            return 6;
        }
        ParamParent paramParent = (ParamParent)tag;
        String string = this.value;
        if (string == null) {
            string = this.bodyContent == null || this.bodyContent.getString() == null ? "" : this.bodyContent.getString().trim();
        }
        if (this.encode) {
            String string2 = this.pageContext.getResponse().getCharacterEncoding();
            paramParent.addParameter(Util.URLEncode(this.name, string2), Util.URLEncode(string, string2));
        } else {
            paramParent.addParameter(this.name, string);
        }
        return 6;
    }

    public void release() {
        this.init();
    }

    public static class ParamManager {
        private List names = new LinkedList();
        private List values = new LinkedList();
        private boolean done = false;

        public void addParameter(String string, String string2) {
            if (this.done) {
                throw new IllegalStateException();
            }
            if (string != null) {
                this.names.add(string);
                if (string2 != null) {
                    this.values.add(string2);
                } else {
                    this.values.add("");
                }
            }
        }

        public String aggregateParams(String string) {
            int n;
            if (this.done) {
                throw new IllegalStateException();
            }
            this.done = true;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < this.names.size(); ++n) {
                stringBuffer.append(this.names.get(n) + "=" + this.values.get(n));
                if (n >= this.names.size() - 1) continue;
                stringBuffer.append("&");
            }
            if (stringBuffer.length() > 0) {
                n = string.indexOf(63);
                if (n == -1) {
                    return string + "?" + stringBuffer;
                }
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.insert(n + 1, stringBuffer + "&");
                return stringBuffer2.toString();
            }
            return string;
        }
    }
}

