/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegateMBean;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class MBeanServerDelegate
implements MBeanServerDelegateMBean,
NotificationEmitter {
    private static long mbeanServerCount;
    private static final MBeanNotificationInfo[] notifications;
    private String mbeanServerID;
    private NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifications;
    }

    public void sendNotification(Notification notification) {
        this.broadcaster.sendNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMBeanServerId() {
        MBeanServerDelegate mBeanServerDelegate = this;
        synchronized (mBeanServerDelegate) {
            if (this.mbeanServerID == null) {
                this.mbeanServerID = this.generateMBeanServerID();
            }
        }
        return this.mbeanServerID;
    }

    public String getImplementationName() {
        return "MX4J";
    }

    public String getImplementationVendor() {
        return "The MX4J Team";
    }

    public String getImplementationVersion() {
        return "3.0.1";
    }

    public String getSpecificationName() {
        return "Java Management Extensions";
    }

    public String getSpecificationVendor() {
        return "Sun Microsystems";
    }

    public String getSpecificationVersion() {
        return "1.2 Maintenance Release";
    }

    private String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ignored) {
            return "localhost";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateMBeanServerID() {
        long count = 0L;
        Class<MBeanServerDelegate> clazz = MBeanServerDelegate.class;
        synchronized (MBeanServerDelegate.class) {
            count = ++mbeanServerCount;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            UID uid = new UID();
            return uid.toString() + ":" + this.getLocalHost() + ":" + count;
        }
    }

    static {
        notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"JMX.mbean.registered", "JMX.mbean.unregistered"}, MBeanServerNotification.class.getName(), "Notifications emitted by the MBeanServerDelegate MBean upon registration or unregistration of MBeans")};
    }
}

