/*
 * Decompiled with CFR 0.152.
 */
package mx4j;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import mx4j.util.Utils;

public abstract class AbstractDynamicMBean
implements DynamicMBean {
    private MBeanInfo info;
    private Object resource;

    protected AbstractDynamicMBean() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new AttributeNotFoundException("Attribute " + attribute + " not found");
        }
        Object resource = null;
        MBeanInfo info = null;
        AbstractDynamicMBean abstractDynamicMBean = this;
        synchronized (abstractDynamicMBean) {
            resource = this.getResourceOrThis();
            info = this.getMBeanInfo();
        }
        MBeanAttributeInfo[] attrs = info.getAttributes();
        if (attrs == null || attrs.length == 0) {
            throw new AttributeNotFoundException("No attributes defined for this MBean");
        }
        for (int i = 0; i < attrs.length; ++i) {
            MBeanAttributeInfo attr = attrs[i];
            if (attr == null || !attribute.equals(attr.getName())) continue;
            if (!attr.isReadable()) {
                throw new ReflectionException(new NoSuchMethodException("No getter defined for attribute: " + attribute));
            }
            String prefix = null;
            prefix = attr.isIs() ? "is" : "get";
            try {
                return this.invoke(resource, prefix + attr.getName(), new Class[0], new Object[0]);
            }
            catch (InvalidAttributeValueException x) {
                throw new ReflectionException(x);
            }
        }
        throw new AttributeNotFoundException("Attribute " + attribute + " not found");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                String attribute = attributes[i];
                try {
                    Object result = this.getAttribute(attribute);
                    list.add(new Attribute(attribute, result));
                    continue;
                }
                catch (AttributeNotFoundException ignored) {
                    continue;
                }
                catch (MBeanException ignored) {
                    continue;
                }
                catch (ReflectionException ignored) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(this.createMBeanInfo());
        }
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        if (method == null) {
            throw new IllegalArgumentException("Method name cannot be null");
        }
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (params == null) {
            params = new String[]{};
        }
        Object resource = null;
        MBeanInfo info = null;
        AbstractDynamicMBean abstractDynamicMBean = this;
        synchronized (abstractDynamicMBean) {
            resource = this.getResourceOrThis();
            info = this.getMBeanInfo();
        }
        MBeanOperationInfo[] opers = info.getOperations();
        if (opers == null || opers.length == 0) {
            throw new ReflectionException(new NoSuchMethodException("No operations defined for this MBean"));
        }
        for (int i = 0; i < opers.length; ++i) {
            MBeanParameterInfo[] parameters;
            MBeanOperationInfo oper = opers[i];
            if (oper == null || !method.equals(oper.getName()) || params.length != (parameters = oper.getSignature()).length) continue;
            Object[] signature = new String[parameters.length];
            for (int j = 0; j < signature.length; ++j) {
                MBeanParameterInfo param = parameters[j];
                signature[j] = param == null ? null : param.getType();
            }
            if (!Utils.arrayEquals(params, signature)) continue;
            try {
                Class[] classes = Utils.loadClasses(resource.getClass().getClassLoader(), (String[])signature);
                return this.invoke(resource, method, classes, arguments);
            }
            catch (ClassNotFoundException x) {
                throw new ReflectionException(x);
            }
            catch (InvalidAttributeValueException x) {
                throw new ReflectionException(x);
            }
        }
        throw new ReflectionException(new NoSuchMethodException("Operation " + method + " with signature " + Arrays.asList(params) + " is not defined for this MBean"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new AttributeNotFoundException("Attribute " + attribute + " not found");
        }
        Object resource = null;
        MBeanInfo info = null;
        AbstractDynamicMBean abstractDynamicMBean = this;
        synchronized (abstractDynamicMBean) {
            resource = this.getResourceOrThis();
            info = this.getMBeanInfo();
        }
        MBeanAttributeInfo[] attrs = info.getAttributes();
        if (attrs == null || attrs.length == 0) {
            throw new AttributeNotFoundException("No attributes defined for this MBean");
        }
        for (int i = 0; i < attrs.length; ++i) {
            MBeanAttributeInfo attr = attrs[i];
            if (attr == null || !attribute.getName().equals(attr.getName())) continue;
            if (!attr.isWritable()) {
                throw new ReflectionException(new NoSuchMethodException("No setter defined for attribute: " + attribute));
            }
            try {
                String signature = attr.getType();
                Class cls = Utils.loadClass(resource.getClass().getClassLoader(), signature);
                this.invoke(resource, "set" + attr.getName(), new Class[]{cls}, new Object[]{attribute.getValue()});
                return;
            }
            catch (ClassNotFoundException x) {
                throw new ReflectionException(x);
            }
        }
        throw new AttributeNotFoundException("Attribute " + attribute + " not found");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        if (attributes != null) {
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attribute = (Attribute)attributes.get(i);
                try {
                    this.setAttribute(attribute);
                    list.add(attribute);
                    continue;
                }
                catch (AttributeNotFoundException ignored) {
                    continue;
                }
                catch (InvalidAttributeValueException ignored) {
                    continue;
                }
                catch (MBeanException ignored) {
                    continue;
                }
                catch (ReflectionException ignored) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    protected Object invoke(String name, Class[] params, Object[] args) throws InvalidAttributeValueException, MBeanException, ReflectionException {
        Object resource = this.getResourceOrThis();
        return this.invoke(resource, name, params, args);
    }

    protected Object invoke(Object resource, String name, Class[] params, Object[] args) throws InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Class<?> cls = resource.getClass();
            Method method = this.findMethod(cls, name, params);
            return this.invokeMethod(method, resource, args);
        }
        catch (NoSuchMethodException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalArgumentException x) {
            throw new InvalidAttributeValueException(x.toString());
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            throw new RuntimeErrorException((Error)t);
        }
    }

    protected Method findMethod(Class cls, String name, Class[] params) throws NoSuchMethodException {
        return cls.getMethod(name, params);
    }

    protected Object invokeMethod(Method method, Object resource, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke(resource, args);
    }

    private Object getResourceOrThis() {
        Object resource = this.getResource();
        if (resource == null) {
            resource = this;
        }
        return resource;
    }

    protected synchronized Object getResource() {
        return this.resource;
    }

    public synchronized void setResource(Object resource) {
        this.resource = resource;
    }

    protected synchronized void setMBeanInfo(MBeanInfo info) {
        this.info = info;
    }

    protected MBeanInfo createMBeanInfo() {
        MBeanAttributeInfo[] attrs = this.createMBeanAttributeInfo();
        MBeanConstructorInfo[] ctors = this.createMBeanConstructorInfo();
        MBeanOperationInfo[] opers = this.createMBeanOperationInfo();
        MBeanNotificationInfo[] notifs = this.createMBeanNotificationInfo();
        String className = this.getMBeanClassName();
        String description = this.getMBeanDescription();
        return new MBeanInfo(className, description, attrs, ctors, opers, notifs);
    }

    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        return null;
    }

    protected MBeanConstructorInfo[] createMBeanConstructorInfo() {
        return null;
    }

    protected MBeanOperationInfo[] createMBeanOperationInfo() {
        return null;
    }

    protected MBeanNotificationInfo[] createMBeanNotificationInfo() {
        return null;
    }

    protected String getMBeanClassName() {
        return this.getClass().getName();
    }

    protected String getMBeanDescription() {
        return null;
    }
}

