/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.actions;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.tiles.TilesUtil;

public class DefinitionDispatcherAction
extends Action {
    protected static Log log = LogFactory.getLog(DefinitionDispatcherAction.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name;
        String parameter = mapping.getParameter();
        if (parameter == null) {
            parameter = "def";
        }
        if ((name = request.getParameter(parameter)) == null) {
            log.error((Object)("Can't get parameter '" + parameter + "'."));
            return mapping.findForward("error");
        }
        try {
            ComponentDefinition definition = TilesUtil.getDefinition(name, (ServletRequest)request, this.getServlet().getServletContext());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get Definition " + definition));
            }
            DefinitionsUtil.setActionDefinition((ServletRequest)request, definition);
        }
        catch (FactoryNotFoundException e) {
            log.error((Object)"Can't get definition factory.", (Throwable)e);
            return mapping.findForward("error");
        }
        catch (NoSuchDefinitionException e) {
            log.error((Object)("Can't get definition '" + name + "'."), (Throwable)e);
            return mapping.findForward("error");
        }
        catch (DefinitionsFactoryException e) {
            log.error((Object)("General Factory error '" + e.getMessage() + "'."), (Throwable)e);
            return mapping.findForward("error");
        }
        catch (Exception e) {
            log.error((Object)("General error '" + e.getMessage() + "'."), (Throwable)e);
            return mapping.findForward("error");
        }
        return mapping.findForward("success");
    }

    protected void printError(HttpServletResponse response, String msg) throws IOException {
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        writer.println(msg);
        writer.flush();
        writer.close();
    }
}

