/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.UrlValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.validator.Resources;

public class FieldChecks
implements Serializable {
    private static final Log log = LogFactory.getLog(FieldChecks.class);
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";

    public static boolean validateRequired(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateRequiredIf(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean required = false;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        int i = 0;
        String fieldJoin = "AND";
        if (!GenericValidator.isBlankOrNull((String)field.getVarValue("fieldJoin"))) {
            fieldJoin = field.getVarValue("fieldJoin");
        }
        if (fieldJoin.equalsIgnoreCase("AND")) {
            required = true;
        }
        while (!GenericValidator.isBlankOrNull((String)field.getVarValue("field[" + i + "]"))) {
            String key;
            String dependProp = field.getVarValue("field[" + i + "]");
            String dependTest = field.getVarValue("fieldTest[" + i + "]");
            String dependTestValue = field.getVarValue("fieldValue[" + i + "]");
            String dependIndexed = field.getVarValue("fieldIndexed[" + i + "]");
            if (dependIndexed == null) {
                dependIndexed = "false";
            }
            String dependVal = null;
            boolean thisRequired = false;
            if (field.isIndexed() && dependIndexed.equalsIgnoreCase("true") && (key = field.getKey()).indexOf("[") > -1 && key.indexOf("]") > -1) {
                String ind = key.substring(0, key.indexOf(".") + 1);
                dependProp = ind + dependProp;
            }
            dependVal = ValidatorUtils.getValueAsString((Object)form, (String)dependProp);
            if (dependTest.equals(FIELD_TEST_NULL)) {
                thisRequired = dependVal == null || dependVal.length() <= 0;
            }
            if (dependTest.equals(FIELD_TEST_NOTNULL)) {
                thisRequired = dependVal != null && dependVal.length() > 0;
            }
            if (dependTest.equals(FIELD_TEST_EQUAL)) {
                thisRequired = dependTestValue.equalsIgnoreCase(dependVal);
            }
            required = fieldJoin.equalsIgnoreCase("AND") ? required && thisRequired : required || thisRequired;
            ++i;
        }
        if (required) {
            if (GenericValidator.isBlankOrNull((String)value)) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateMask(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String mask = field.getVarValue("mask");
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        try {
            if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.matchRegexp((String)value, (String)mask)) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public static Object validateByte(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Byte result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatByte((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateShort(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Short result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatShort((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateInteger(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Integer result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatInt((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateLong(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Long result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatLong((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateFloat(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Float result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatFloat((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateDouble(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Double result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatDouble((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateDate(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Date result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");
        Locale locale = RequestUtils.getUserLocale(request, null);
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        try {
            result = datePattern != null && datePattern.length() > 0 ? GenericTypeValidator.formatDate((String)value, (String)datePattern, (boolean)false) : (datePatternStrict != null && datePatternStrict.length() > 0 ? GenericTypeValidator.formatDate((String)value, (String)datePatternStrict, (boolean)true) : GenericTypeValidator.formatDate((String)value, (Locale)locale));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? Boolean.FALSE : result;
    }

    public static boolean validateIntRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int intValue = Integer.parseInt(value);
                int min = Integer.parseInt(field.getVarValue("min"));
                int max = Integer.parseInt(field.getVarValue("max"));
                if (!GenericValidator.isInRange((int)intValue, (int)min, (int)max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateDoubleRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                double doubleValue = Double.parseDouble(value);
                double min = Double.parseDouble(field.getVarValue("min"));
                double max = Double.parseDouble(field.getVarValue("max"));
                if (!GenericValidator.isInRange((double)doubleValue, (double)min, (double)max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateFloatRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                float floatValue = Float.parseFloat(value);
                float min = Float.parseFloat(field.getVarValue("min"));
                float max = Float.parseFloat(field.getVarValue("max"));
                if (!GenericValidator.isInRange((float)floatValue, (float)min, (float)max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    public static Object validateCreditCard(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Long result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatCreditCard((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static boolean validateEmail(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isEmail((String)value)) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateMaxLength(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (value != null) {
            try {
                int max = Integer.parseInt(field.getVarValue("maxlength"));
                if (!GenericValidator.maxLength((String)value, (int)max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateMinLength(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int min = Integer.parseInt(field.getVarValue("minlength"));
                if (!GenericValidator.minLength((String)value, (int)min)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateUrl(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        UrlValidator urlValidator;
        String schemesVar;
        int options;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        boolean allowallschemes = "true".equalsIgnoreCase(field.getVarValue("allowallschemes"));
        int n = options = allowallschemes ? 1 : 0;
        if ("true".equalsIgnoreCase(field.getVarValue("allow2slashes"))) {
            options += 2;
        }
        if ("true".equalsIgnoreCase(field.getVarValue("nofragments"))) {
            options += 4;
        }
        String string = schemesVar = allowallschemes ? null : field.getVarValue("schemes");
        if (options == 0 && schemesVar == null) {
            if (GenericValidator.isUrl((String)value)) {
                return true;
            }
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        String[] schemes = null;
        if (schemesVar != null) {
            StringTokenizer st = new StringTokenizer(schemesVar, ",");
            schemes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                schemes[i++] = st.nextToken().trim();
            }
        }
        if ((urlValidator = new UrlValidator(schemes, options)).isValid(value)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        return false;
    }

    protected static boolean isString(Object o) {
        return o == null ? true : String.class.isInstance(o);
    }
}

