/*
 * This file implements the COVALENT-APACHE-SERVER-MIB module.
 * $Id: server-globals.c 8676 2008-01-17 23:11:17Z ispringer $
 */
 
#include <httpd.h>
#include <scoreboard.h>
#include <ap_mpm.h>
#include <apr_time.h>

/* SNMP includes */
#include "ucd-snmp-config.h"
#include "asn1.h"
#include "snmp.h"
#include "snmp_api.h"
#include "snmp_impl.h"
#include "snmp_debug.h"
#include "snmp_vars.h"
#include "var_struct.h"

/* module includes */
#include "covalent-snmp-config.h"
#include "snmpcommon/snmpv2-tc.h"
#include "snmpcommon/snmpcommon.h"
#include "apache-server-mib.h"

#ifdef COVALENT_APACHE_SERVER_BASIC_GROUP
/* the basic server managed objects. */
#define CTASSTARTTIME          1
#define CTASRESTARTTIME        2
#define CTASGENERATION         3
#define CTASEXTENDEDSTATUS     4
#define CTASHOSTNAMELOOKUP     5

FindVarMethod var_ctApacheServerTable;
static global_score *globalscore_ptr =  NULL;
static apr_time_t start_time;

/* Wrapper around the start time and is done to
 * use it for the notifications as well.
 * We need to maintain * this ourselves, since
 * Apache does it not for us. :-((
 */
apr_time_t
get_ctApacheStartTime(void)
{
    return(start_time);
}

unsigned long
get_generation(void)
{
    return(globalscore_ptr->running_generation);
}
unsigned char *
var_ctApacheServerTable(struct variable *vp,
    oid *name, size_t *length,
    int exact, size_t *var_len, WriteMethod **write_method)
{
int result;

    DEBUGTRACE;
    DEBUGMSGOID(("sever-basic-mib", name, *length));
    DEBUGMSG(("sever-basic-mib"," %s\n", (exact ? "exact" : "next")));

    vp->name[ vp->namelen - 1 ] = get_appl_index();
    result = snmp_oid_compare(name, *length, vp->name, vp->namelen);
    if ((exact && (result != 0)) || (!exact && (result >= 0))) {
        return(NULL);
    }
    memcpy((char *)name,(char *)vp->name, vp->namelen * sizeof(oid));
    *length = vp->namelen;
    *write_method = NULL; /* Since we implement read-only. */
    *var_len = sizeof(long_return);

    switch (vp->magic) {
        case CTASSTARTTIME:
            *var_len = snmp_time2DateAndTime(get_ctApacheStartTime(), return_buf);
            return (unsigned char *) return_buf;
        case CTASRESTARTTIME:
            *var_len = snmp_time2DateAndTime(globalscore_ptr->restart_time,
                                             return_buf);
            return (unsigned char *) return_buf;
        case CTASGENERATION:
            if (globalscore_ptr) {
                *var_len = sizeof(long);
		long_return = get_generation();
                return (unsigned char *) &long_return;
            }
            return(NULL);
        case CTASEXTENDEDSTATUS:
            long_return = 1;
            return (unsigned char *) &(long_return);
        case CTASHOSTNAMELOOKUP:
            long_return = 1;
            return (unsigned char *) &(long_return);
    }
    return NULL;
}


/* We add a 0 as last OID to be filled with the applIndex. Each registration */
/* is by t his implementation limited to only 1 entry.                       */
/* (Makes table implementation like scalars which is simple and allows for   */ 
/* multiple registrations of Apache)                                         */
static oid ctASBasic_oid[] = {1, 3, 6, 1, 4, 1, 6100, 9, 1, 1, 1};
struct variable2 ctASBasic_variables[] = {
    { CTASSTARTTIME, ASN_OCTET_STR, RONLY, var_ctApacheServerTable, 2, {1, 0} },
    { CTASRESTARTTIME, ASN_OCTET_STR, RONLY, var_ctApacheServerTable, 2, {2, 0} },
    { CTASGENERATION, ASN_UNSIGNED, RWRITE, var_ctApacheServerTable, 2, {3, 0} },
    { CTASEXTENDEDSTATUS, ASN_INTEGER, RWRITE, var_ctApacheServerTable, 2, {4, 0} },
    { CTASHOSTNAMELOOKUP, ASN_INTEGER, RWRITE, var_ctApacheServerTable, 2, {5, 0} }
};

void
init_covalent_apache_server_table()
{
    DEBUGTRACE;
    globalscore_ptr = ap_get_scoreboard_global();
    REGISTER_MIB("covalent-apache-server-mib/ctApacheServerBasic",
		ctASBasic_variables, variable2,
		ctASBasic_oid);

    start_time = globalscore_ptr->restart_time;
}
#endif /* COVALENT_APACHE_SERVER_BASIC_GROUP */

