/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class SyntheticMethodBinding
extends MethodBinding {
    public FieldBinding targetReadField;
    public FieldBinding targetWriteField;
    public MethodBinding targetMethod;
    public TypeBinding targetEnumType;
    public int purpose;
    public int startIndex;
    public int endIndex;
    public static final int FieldReadAccess = 1;
    public static final int FieldWriteAccess = 2;
    public static final int SuperFieldReadAccess = 3;
    public static final int SuperFieldWriteAccess = 4;
    public static final int MethodAccess = 5;
    public static final int ConstructorAccess = 6;
    public static final int SuperMethodAccess = 7;
    public static final int BridgeMethod = 8;
    public static final int EnumValues = 9;
    public static final int EnumValueOf = 10;
    public static final int SwitchTable = 11;
    public static final int TooManyEnumsConstants = 12;
    public int sourceStart = 0;
    public int index;

    public SyntheticMethodBinding(FieldBinding targetField, boolean isReadAccess, boolean isSuperAccess, ReferenceBinding declaringClass) {
        boolean needRename;
        int methodId;
        this.modifiers = 4104;
        this.tagBits |= 0x600000000L;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)declaringClass;
        SyntheticMethodBinding[] knownAccessMethods = declaringSourceType.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(methodId).toCharArray());
        if (isReadAccess) {
            this.returnType = targetField.type;
            if (targetField.isStatic()) {
                this.parameters = Binding.NO_PARAMETERS;
            } else {
                this.parameters = new TypeBinding[1];
                this.parameters[0] = declaringSourceType;
            }
            this.targetReadField = targetField;
            this.purpose = isSuperAccess ? 3 : 1;
        } else {
            this.returnType = TypeBinding.VOID;
            if (targetField.isStatic()) {
                this.parameters = new TypeBinding[1];
                this.parameters[0] = targetField.type;
            } else {
                this.parameters = new TypeBinding[2];
                this.parameters[0] = declaringSourceType;
                this.parameters[1] = targetField.type;
            }
            this.targetWriteField = targetField;
            this.purpose = isSuperAccess ? 4 : 2;
        }
        this.thrownExceptions = Binding.NO_EXCEPTIONS;
        this.declaringClass = declaringSourceType;
        do {
            needRename = false;
            MethodBinding[] methods = declaringSourceType.methods();
            long range = ReferenceBinding.binarySearch(this.selector, methods);
            if (range >= 0L) {
                int paramCount = this.parameters.length;
                int end = (int)(range >> 32);
                block1: for (int imethod = (int)range; imethod <= end; ++imethod) {
                    MethodBinding method = methods[imethod];
                    if (method.parameters.length != paramCount) continue;
                    TypeBinding[] toMatch = method.parameters;
                    for (int i = 0; i < paramCount; ++i) {
                        if (toMatch[i] != this.parameters[i]) continue block1;
                    }
                    needRename = true;
                    break;
                }
            } else if (knownAccessMethods != null) {
                int length = knownAccessMethods.length;
                for (int i = 0; i < length; ++i) {
                    if (knownAccessMethods[i] == null || !CharOperation.equals(this.selector, knownAccessMethods[i].selector) || !this.areParametersEqual(methods[i])) continue;
                    needRename = true;
                    break;
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        FieldDeclaration[] fieldDecls = declaringSourceType.scope.referenceContext.fields;
        if (fieldDecls != null) {
            int max = fieldDecls.length;
            for (int i = 0; i < max; ++i) {
                if (fieldDecls[i].binding != targetField) continue;
                this.sourceStart = fieldDecls[i].sourceStart;
                return;
            }
        }
        this.sourceStart = declaringSourceType.scope.referenceContext.sourceStart;
    }

    public SyntheticMethodBinding(FieldBinding targetField, ReferenceBinding declaringClass, TypeBinding enumBinding, char[] selector) {
        boolean needRename;
        int methodId;
        this.modifiers = 4104;
        this.tagBits |= 0x600000000L;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)declaringClass;
        SyntheticMethodBinding[] knownAccessMethods = declaringSourceType.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = selector;
        this.returnType = declaringSourceType.scope.createArrayType(TypeBinding.INT, 1);
        this.parameters = Binding.NO_PARAMETERS;
        this.targetReadField = targetField;
        this.targetEnumType = enumBinding;
        this.purpose = 11;
        this.thrownExceptions = Binding.NO_EXCEPTIONS;
        this.declaringClass = declaringSourceType;
        if (declaringSourceType.isStrictfp()) {
            this.modifiers |= 0x800;
        }
        do {
            needRename = false;
            MethodBinding[] methods = declaringSourceType.methods();
            long range = ReferenceBinding.binarySearch(this.selector, methods);
            if (range >= 0L) {
                int paramCount = this.parameters.length;
                int end = (int)(range >> 32);
                block1: for (int imethod = (int)range; imethod <= end; ++imethod) {
                    MethodBinding method = methods[imethod];
                    if (method.parameters.length != paramCount) continue;
                    TypeBinding[] toMatch = method.parameters;
                    for (int i = 0; i < paramCount; ++i) {
                        if (toMatch[i] != this.parameters[i]) continue block1;
                    }
                    needRename = true;
                    break;
                }
            } else if (knownAccessMethods != null) {
                int length = knownAccessMethods.length;
                for (int i = 0; i < length; ++i) {
                    if (knownAccessMethods[i] == null || !CharOperation.equals(this.selector, knownAccessMethods[i].selector) || !this.areParametersEqual(methods[i])) continue;
                    needRename = true;
                    break;
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(selector, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        this.sourceStart = declaringSourceType.scope.referenceContext.sourceStart;
    }

    public SyntheticMethodBinding(MethodBinding targetMethod, boolean isSuperAccess, ReferenceBinding declaringClass) {
        if (targetMethod.isConstructor()) {
            this.initializeConstructorAccessor(targetMethod);
        } else {
            this.initializeMethodAccessor(targetMethod, isSuperAccess, declaringClass);
        }
    }

    public SyntheticMethodBinding(MethodBinding overridenMethodToBridge, MethodBinding targetMethod, SourceTypeBinding declaringClass) {
        int methodId;
        this.declaringClass = declaringClass;
        this.selector = overridenMethodToBridge.selector;
        this.modifiers = (targetMethod.modifiers | 0x40 | 0x1000) & 0xBFFFFACF;
        this.tagBits |= 0x600000000L;
        this.returnType = overridenMethodToBridge.returnType;
        this.parameters = overridenMethodToBridge.parameters;
        this.thrownExceptions = overridenMethodToBridge.thrownExceptions;
        this.targetMethod = targetMethod;
        this.purpose = 8;
        SyntheticMethodBinding[] knownAccessMethods = declaringClass.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
    }

    public SyntheticMethodBinding(SourceTypeBinding declaringEnum, char[] selector) {
        int methodId;
        this.declaringClass = declaringEnum;
        this.selector = selector;
        this.modifiers = 9;
        this.tagBits |= 0x600000000L;
        LookupEnvironment environment = declaringEnum.scope.environment();
        this.thrownExceptions = Binding.NO_EXCEPTIONS;
        if (selector == TypeConstants.VALUES) {
            this.returnType = environment.createArrayType(environment.convertToParameterizedType(declaringEnum), 1);
            this.parameters = Binding.NO_PARAMETERS;
            this.purpose = 9;
        } else if (selector == TypeConstants.VALUEOF) {
            this.returnType = environment.convertToParameterizedType(declaringEnum);
            this.parameters = new TypeBinding[]{declaringEnum.scope.getJavaLangString()};
            this.purpose = 10;
        }
        SyntheticMethodBinding[] knownAccessMethods = ((SourceTypeBinding)this.declaringClass).syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        if (declaringEnum.isStrictfp()) {
            this.modifiers |= 0x800;
        }
    }

    public SyntheticMethodBinding(SourceTypeBinding declaringEnum, int startIndex, int endIndex) {
        this.declaringClass = declaringEnum;
        SyntheticMethodBinding[] knownAccessMethods = declaringEnum.syntheticMethods();
        this.index = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        StringBuffer buffer = new StringBuffer();
        buffer.append(TypeConstants.SYNTHETIC_ENUM_CONSTANT_INITIALIZATION_METHOD_PREFIX).append(this.index);
        this.selector = String.valueOf(buffer).toCharArray();
        this.modifiers = 10;
        this.tagBits |= 0x600000000L;
        this.purpose = 12;
        this.thrownExceptions = Binding.NO_EXCEPTIONS;
        this.returnType = TypeBinding.VOID;
        this.parameters = Binding.NO_PARAMETERS;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public SyntheticMethodBinding(MethodBinding overridenMethodToBridge, SourceTypeBinding declaringClass) {
        int methodId;
        this.declaringClass = declaringClass;
        this.selector = overridenMethodToBridge.selector;
        this.modifiers = (overridenMethodToBridge.modifiers | 0x40 | 0x1000) & 0xBFFFFACF;
        this.tagBits |= 0x600000000L;
        this.returnType = overridenMethodToBridge.returnType;
        this.parameters = overridenMethodToBridge.parameters;
        this.thrownExceptions = overridenMethodToBridge.thrownExceptions;
        this.targetMethod = overridenMethodToBridge;
        this.purpose = 7;
        SyntheticMethodBinding[] knownAccessMethods = declaringClass.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
    }

    public void initializeConstructorAccessor(MethodBinding accessedConstructor) {
        int i;
        int length;
        boolean needRename;
        this.targetMethod = accessedConstructor;
        this.modifiers = 4096;
        this.tagBits |= 0x600000000L;
        SourceTypeBinding sourceType = (SourceTypeBinding)accessedConstructor.declaringClass;
        SyntheticMethodBinding[] knownSyntheticMethods = sourceType.syntheticMethods();
        this.index = knownSyntheticMethods == null ? 0 : knownSyntheticMethods.length;
        this.selector = accessedConstructor.selector;
        this.returnType = accessedConstructor.returnType;
        this.purpose = 6;
        int parametersLength = accessedConstructor.parameters.length;
        this.parameters = new TypeBinding[parametersLength + 1];
        System.arraycopy(accessedConstructor.parameters, 0, this.parameters, 0, parametersLength);
        this.parameters[parametersLength] = accessedConstructor.declaringClass;
        this.thrownExceptions = accessedConstructor.thrownExceptions;
        this.declaringClass = sourceType;
        do {
            block6: {
                needRename = false;
                MethodBinding[] methods = sourceType.methods();
                length = methods.length;
                for (i = 0; i < length; ++i) {
                    if (!CharOperation.equals(this.selector, methods[i].selector) || !this.areParameterErasuresEqual(methods[i])) continue;
                    needRename = true;
                    break block6;
                }
                if (knownSyntheticMethods != null) {
                    length = knownSyntheticMethods.length;
                    for (i = 0; i < length; ++i) {
                        if (knownSyntheticMethods[i] == null || !CharOperation.equals(this.selector, knownSyntheticMethods[i].selector) || !this.areParameterErasuresEqual(knownSyntheticMethods[i])) continue;
                        needRename = true;
                        break;
                    }
                }
            }
            if (!needRename) continue;
            int length2 = this.parameters.length;
            this.parameters = new TypeBinding[length2 + 1];
            System.arraycopy(this.parameters, 0, this.parameters, 0, length2);
            this.parameters[length2] = this.declaringClass;
        } while (needRename);
        AbstractMethodDeclaration[] methodDecls = sourceType.scope.referenceContext.methods;
        if (methodDecls != null) {
            length = methodDecls.length;
            for (i = 0; i < length; ++i) {
                if (methodDecls[i].binding != accessedConstructor) continue;
                this.sourceStart = methodDecls[i].sourceStart;
                return;
            }
        }
    }

    public void initializeMethodAccessor(MethodBinding accessedMethod, boolean isSuperAccess, ReferenceBinding receiverType) {
        int i;
        int length;
        boolean needRename;
        int methodId;
        this.targetMethod = accessedMethod;
        this.modifiers = 4104;
        this.tagBits |= 0x600000000L;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)receiverType;
        SyntheticMethodBinding[] knownAccessMethods = declaringSourceType.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(methodId).toCharArray());
        this.returnType = accessedMethod.returnType;
        int n = this.purpose = isSuperAccess ? 7 : 5;
        if (accessedMethod.isStatic()) {
            this.parameters = accessedMethod.parameters;
        } else {
            this.parameters = new TypeBinding[accessedMethod.parameters.length + 1];
            this.parameters[0] = declaringSourceType;
            System.arraycopy(accessedMethod.parameters, 0, this.parameters, 1, accessedMethod.parameters.length);
        }
        this.thrownExceptions = accessedMethod.thrownExceptions;
        this.declaringClass = declaringSourceType;
        do {
            block8: {
                needRename = false;
                MethodBinding[] methods = declaringSourceType.methods();
                length = methods.length;
                for (i = 0; i < length; ++i) {
                    if (!CharOperation.equals(this.selector, methods[i].selector) || !this.areParameterErasuresEqual(methods[i])) continue;
                    needRename = true;
                    break block8;
                }
                if (knownAccessMethods != null) {
                    length = knownAccessMethods.length;
                    for (i = 0; i < length; ++i) {
                        if (knownAccessMethods[i] == null || !CharOperation.equals(this.selector, knownAccessMethods[i].selector) || !this.areParameterErasuresEqual(knownAccessMethods[i])) continue;
                        needRename = true;
                        break;
                    }
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        AbstractMethodDeclaration[] methodDecls = declaringSourceType.scope.referenceContext.methods;
        if (methodDecls != null) {
            length = methodDecls.length;
            for (i = 0; i < length; ++i) {
                if (methodDecls[i].binding != accessedMethod) continue;
                this.sourceStart = methodDecls[i].sourceStart;
                return;
            }
        }
    }

    protected boolean isConstructorRelated() {
        return this.purpose == 6;
    }
}

