dnl modules (SNMP agents) enabled in this directory by default

AC_ARG_WITH(snmp-agt,
[
------ Start of SNMP specific options ------------------------------------------
  --with-snmp-agt=DIR            enables the SNMP agent (module).
                                 The module will be build statically in 
                                 the DIR directory of the Apache tree.],
[
(   echo
    echo "Start configuration of SNMP module"
    echo " cd $withval"
    echo " ./autogen.sh $ac_configure_args \"
    echo "        --with-static-snmp-agt=$abs_srcdir \"
    echo "        --with-mpm=$APACHE_MPM --with-os-include=$OS"
    cd $withval 
    if eval ./autogen.sh $ac_configure_args \
		--with-static-snmp-agt=$abs_srcdir \
		--with-mpm=$MPM_NAME \
		--with-os-include=$OS_DIR ;
    then
        echo "$withval configured properly"
    else
        echo "configure failed for $withval"
        exit 1
    fi
)

    MODLIST="$MODLIST apache_snmp_agt"
    MODLIST="$MODLIST apache_logging_subagt"
    if test 0 -ne `echo $withval | grep -c "^\/"` ; then
        echo "absolut path $withval"
        MODULE_DIRS="$MODULE_DIRS $withval"
    else
        if test 0 -ne `echo $withval | grep -c "^modules\/"` ; then
            mod_dir=`echo $withval | sed -e "s/modules\///g"`
            echo "relative path $mod_dir"
            MODULE_DIRS="$MODULE_DIRS $mod_dir"
        fi
    fi
    BUILTIN_LIBS="$BUILTIN_LIBS $withval/src/libsnmp_subagt.a"
    BUILTIN_LIBS="$BUILTIN_LIBS $withval/src/libsnmp_logging_agt.a"

    echo
    echo "End configuration of SNMP module"
    echo
])

AC_ARG_ENABLE(developer,
[  --enable-developer             Turns on extra-compile-warnings when using gcc],
[ ])

AC_ARG_ENABLE(evaluation,
[  --enable-evaluation            enable building of the evaluation version],
[ ])

AC_ARG_WITH(ucd-snmp,
[ Configuring the dependant packages/tools (required):
  --with-ucd-snmp=DIR            DIR is the pathname to the base directory of
                                 a UCD-SNMP source to be used libraries],
[
        if test -f $withval/ucd-snmp-config.h ; then
                BUILTIN_LIBS="$BUILTIN_LIBS $withval/agent/.libs/libucdagent.a"
                BUILTIN_LIBS="$BUILTIN_LIBS $withval/agent/.libs/libucdmibs.a"
                BUILTIN_LIBS="$BUILTIN_LIBS $withval/snmplib/.libs/libsnmp.a"
                AC_MSG_RESULT(yes, at $withval)
        else
                AC_MSG_ERROR(no - Unable to locate $withval/ucd-snmp-config.h)
        fi
],[
        AC_MSG_RESULT(no)
])

AC_ARG_WITH(covalent-sdbm,
[  --with-covalent-sdbm=SDBM      SDBM is the full pathname to the sdbm tool.],
[
        if test -f $withval/libcovalent_sdbm.a; then
                BUILTIN_LIBS="$BUILTIN_LIBS $withval/libcovalent_sdbm.a"
                AC_MSG_RESULT(yes, at $withval)
        else
                AC_MSG_ERROR(no - Unable to locate $withval/libcovalent_sdbm.a)
        fi
],[
        AC_MSG_RESULT(no)
])

AC_ARG_WITH(max-string,
[  --with-max-string=MAX_SNMPADMINSTRING MAX_SNMPADMINSTRING is the maximum size of
		                 an SnmpAdminString or a DisplayString.],
[ ])

AC_ARG_WITH(max-wwwservices,
[  --with-max-wwwservices=MAX_WWW_SERVICES MAX_WWW_SERVICES is the maximum number of
                                 www services (vhosts) allowed in the WWW-MIB],
[ ])

AC_ARG_ENABLE(snmp-lite,
[
  Selecting the required MIB modules or portions there of.
  If none selected no MIB module will be added (no defaults):
  --enable-snmp-lite             enable SNMP-lite (WWW-MIB and NETWORK-SERVICES-MIB)],
[ ])

AC_ARG_ENABLE(www-mib,
[
The WWW-MIB module:
  --enable-www-mib               enable all groups],
[ ])

AC_ARG_ENABLE(www-service,
[  --enable-www-service           enable the wwwServiceGroup only],
[ ])

AC_ARG_ENABLE(www-summary,
[  --enable-www-summary           enable the wwwSummaryGroup only],
[ ])

AC_ARG_ENABLE(www-req-in,
[  --enable-www-req-in            enable the wwwRequestInGroup only],
[ ])

AC_ARG_ENABLE(www-req-out,
[  --enable-www-req-out           enable the wwwRequestOutGroup only],
[ ])

AC_ARG_ENABLE(www-resp-in,
[  --enable-www-resp-in           enable the wwwRequestInGroup only],
[ ])

AC_ARG_ENABLE(www-resp-out,
[  --enable-www-resp-out          enable the wwwResponseOutGroup only],
[ ])

AC_ARG_ENABLE(www-docs,
[  --enable-www-docs              enable the wwwDocumentGroup only],
[ ])

AC_ARG_ENABLE(nsm-mib,
[ The NETWORK-SERVICES-MIB module:
  --enable-nsm-mib               enable the applTable and assocTable],
[ ])

AC_ARG_ENABLE(rtp-mib,
[ The RTP-MIB module:
  --enable-rtp-mib               enable all groups],
[ ])

AC_ARG_ENABLE(rtp-session,
[  --enable-rtp-session           enable the session tables only],
[ ])

AC_ARG_ENABLE(rtp-sender,
[  --enable-rtp-sender            enable the sender tables only],
[ ])

AC_ARG_ENABLE(rtp-receiver,
[  --enable-rtp-receiver          enable the receiver tables only],
[ ])


AC_ARG_ENABLE(resp-notify-mib,
[ The Covalent enterprise MIB modules:
  --enable-resp-notify-mib       enable the COVALENT-RESP-NOTIFY-MIB],
[ ])

AC_ARG_ENABLE(apache-status-mib,
[  --enable-apache-status-mib     enable the COVALENT-APACHE-STATUS-MIB],
[ ])

AC_ARG_ENABLE(apache-modules-mib,
[  --enable-apache-modules-mib    enable the COVALENT-APACHE-MODULES-MIB],
[ ])

AC_ARG_ENABLE(apache-config-mib,
[  --enable-apache-config-mib     enable the COVALENT-APACHE-CONFIG-MIB],
[ ])

AC_ARG_ENABLE(apache-server-mib,
[ The COVALENT-APACHE-SERVER-MIB module:
  --enable-apache-server-mib     enable all groups],
[ ])

AC_ARG_ENABLE(apache-server-basic,
[  --enable-apache-server-basic   enable the ctASBasicGroup only],
[ ])

AC_ARG_ENABLE(apache-mpm-mib,
[ The COVALENT-APACHE-MPM-MIB:
  --enable-apache-mpm-mib        enable complete MIB module (read-only)],
[ ])
AC_ARG_ENABLE(apache-mpm-mib-write,
[  --enable-apache-mpm-mib-write  enable complete MIB module (read-write)],
[ ])

AC_ARG_ENABLE(apache-logging-mib,
[ The COVALENT-APACHE-LOGGING-MIB:
  --enable-apache-logging-mib    enable all groups],
[ ])

AC_ARG_ENABLE(apache-logging-appl,
[  --enable-apache-logging-appl   enable the application portion only],
[ ])
AC_ARG_ENABLE(apache-logging-www,
[  --enable-apache-logging-www    enable the www service portion only
------ End of SNMP specific options --------------------------------------------
],
[ ])

