/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.tomcat.dbcp.collections.CursorableSubList;

public class CursorableLinkedList
implements List,
Serializable {
    private static final long serialVersionUID = 8836393098519411393L;
    protected transient int _size = 0;
    protected transient Listable _head = new Listable(null, null, null);
    protected transient int _modCount = 0;
    protected transient List _cursors = new ArrayList();

    @Override
    public boolean add(Object object) {
        this.insertListable(this._head.prev(), null, object);
        return true;
    }

    public void add(int n, Object object) {
        if (n == this._size) {
            this.add(object);
        } else {
            if (n < 0 || n > this._size) {
                throw new IndexOutOfBoundsException(String.valueOf(n) + " < 0 or " + String.valueOf(n) + " > " + this._size);
            }
            Listable listable = this.isEmpty() ? null : this.getListableAt(n);
            Listable listable2 = null == listable ? null : listable.prev();
            this.insertListable(listable2, listable, object);
        }
    }

    @Override
    public boolean addAll(Collection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.insertListable(this._head.prev(), null, iterator.next());
        }
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (this._size == n || this._size == 0) {
            return this.addAll(collection);
        }
        Listable listable = this.getListableAt(n);
        Listable listable2 = null == listable ? null : listable.prev();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            listable2 = this.insertListable(listable2, listable, iterator.next());
        }
        return true;
    }

    public boolean addFirst(Object object) {
        this.insertListable(null, this._head.next(), object);
        return true;
    }

    public boolean addLast(Object object) {
        this.insertListable(this._head.prev(), null, object);
        return true;
    }

    @Override
    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public boolean contains(Object object) {
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (null != listable && listable2 != this._head.prev()) {
            if (null == object && null == listable.value() || object != null && object.equals(listable.value())) {
                return true;
            }
            listable2 = listable;
            listable = listable2.next();
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Cursor cursor() {
        return new Cursor(0);
    }

    public Cursor cursor(int n) {
        return new Cursor(n);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        ListIterator listIterator = ((List)object).listIterator();
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (null != listable && listable2 != this._head.prev()) {
            if (!listIterator.hasNext() || (null == listable.value() ? null != listIterator.next() : !listable.value().equals(listIterator.next()))) {
                return false;
            }
            listable2 = listable;
            listable = listable2.next();
        }
        return !listIterator.hasNext();
    }

    public Object get(int n) {
        return this.getListableAt(n).value();
    }

    @Override
    public Object getFirst() {
        try {
            return this._head.next().value();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Object getLast() {
        try {
            return this._head.prev().value();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int hashCode() {
        int n = 1;
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (null != listable && listable2 != this._head.prev()) {
            n = 31 * n + (null == listable.value() ? 0 : listable.value().hashCode());
            listable2 = listable;
            listable = listable2.next();
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        if (null == object) {
            Listable listable = this._head.next();
            Listable listable2 = null;
            while (null != listable && listable2 != this._head.prev()) {
                if (null == listable.value()) {
                    return n;
                }
                ++n;
                listable2 = listable;
                listable = listable2.next();
            }
        } else {
            Listable listable = this._head.next();
            Listable listable3 = null;
            while (null != listable && listable3 != this._head.prev()) {
                if (object.equals(listable.value())) {
                    return n;
                }
                ++n;
                listable3 = listable;
                listable = listable3.next();
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this._size - 1;
        if (null == object) {
            Listable listable = this._head.prev();
            Listable listable2 = null;
            while (null != listable && listable2 != this._head.next()) {
                if (null == listable.value()) {
                    return n;
                }
                --n;
                listable2 = listable;
                listable = listable2.prev();
            }
        } else {
            Listable listable = this._head.prev();
            Listable listable3 = null;
            while (null != listable && listable3 != this._head.next()) {
                if (object.equals(listable.value())) {
                    return n;
                }
                --n;
                listable3 = listable;
                listable = listable3.prev();
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException(n + " < 0 or > " + this._size);
        }
        return new ListIter(n);
    }

    @Override
    public boolean remove(Object object) {
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (null != listable && listable2 != this._head.prev()) {
            if (null == object && null == listable.value()) {
                this.removeListable(listable);
                return true;
            }
            if (object != null && object.equals(listable.value())) {
                this.removeListable(listable);
                return true;
            }
            listable2 = listable;
            listable = listable2.next();
        }
        return false;
    }

    public Object remove(int n) {
        Listable listable = this.getListableAt(n);
        Object object = listable.value();
        this.removeListable(listable);
        return object;
    }

    @Override
    public boolean removeAll(Collection collection) {
        if (0 == collection.size() || 0 == this._size) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public Object removeFirst() {
        if (this._head.next() != null) {
            Object object = this._head.next().value();
            this.removeListable(this._head.next());
            return object;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Object removeLast() {
        if (this._head.prev() != null) {
            Object object = this._head.prev().value();
            this.removeListable(this._head.prev());
            return object;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public Object set(int n, Object object) {
        Listable listable = this.getListableAt(n);
        Object object2 = listable.setValue(object);
        this.broadcastListableChanged(listable);
        return object2;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        int n = 0;
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (null != listable && listable2 != this._head.prev()) {
            objectArray[n++] = listable.value();
            listable2 = listable;
            listable = listable2.next();
        }
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this._size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this._size);
        }
        int n = 0;
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (null != listable && listable2 != this._head.prev()) {
            objectArray[n++] = listable.value();
            listable2 = listable;
            listable = listable2.next();
        }
        if (objectArray.length > this._size) {
            objectArray[this._size] = null;
        }
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (null != listable && listable2 != this._head.prev()) {
            if (this._head.next() != listable) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(listable.value());
            listable2 = listable;
            listable = listable2.next();
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public List subList(int n, int n2) {
        if (n < 0 || n2 > this._size || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0 && n2 == this._size) {
            return this;
        }
        return new CursorableSubList(this, n, n2);
    }

    protected Listable insertListable(Listable listable, Listable listable2, Object object) {
        ++this._modCount;
        ++this._size;
        Listable listable3 = new Listable(listable, listable2, object);
        if (null != listable) {
            listable.setNext(listable3);
        } else {
            this._head.setNext(listable3);
        }
        if (null != listable2) {
            listable2.setPrev(listable3);
        } else {
            this._head.setPrev(listable3);
        }
        this.broadcastListableInserted(listable3);
        return listable3;
    }

    protected void removeListable(Listable listable) {
        ++this._modCount;
        --this._size;
        if (this._head.next() == listable) {
            this._head.setNext(listable.next());
        }
        if (null != listable.next()) {
            listable.next().setPrev(listable.prev());
        }
        if (this._head.prev() == listable) {
            this._head.setPrev(listable.prev());
        }
        if (null != listable.prev()) {
            listable.prev().setNext(listable.next());
        }
        this.broadcastListableRemoved(listable);
    }

    protected Listable getListableAt(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException(String.valueOf(n) + " < 0 or " + String.valueOf(n) + " >= " + this._size);
        }
        if (n <= this._size / 2) {
            Listable listable = this._head.next();
            for (int i = 0; i < n; ++i) {
                listable = listable.next();
            }
            return listable;
        }
        Listable listable = this._head.prev();
        for (int i = this._size - 1; i > n; --i) {
            listable = listable.prev();
        }
        return listable;
    }

    protected void registerCursor(Cursor cursor) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
        this._cursors.add(new WeakReference<Cursor>(cursor));
    }

    protected void unregisterCursor(Cursor cursor) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor2 = (Cursor)weakReference.get();
            if (cursor2 == null) {
                iterator.remove();
                continue;
            }
            if (cursor2 != cursor) continue;
            weakReference.clear();
            iterator.remove();
            break;
        }
    }

    protected void invalidateCursors() {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor != null) {
                cursor.invalidate();
                weakReference.clear();
            }
            iterator.remove();
        }
    }

    protected void broadcastListableChanged(Listable listable) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.listableChanged(listable);
        }
    }

    protected void broadcastListableRemoved(Listable listable) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.listableRemoved(listable);
        }
    }

    protected void broadcastListableInserted(Listable listable) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.listableInserted(listable);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        for (Listable listable = this._head.next(); listable != null; listable = listable.next()) {
            objectOutputStream.writeObject(listable.value());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._size = 0;
        this._modCount = 0;
        this._cursors = new ArrayList();
        this._head = new Listable(null, null, null);
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(objectInputStream.readObject());
        }
    }

    public class Cursor
    extends ListIter
    implements ListIterator {
        boolean _valid;

        Cursor(int n) {
            super(n);
            this._valid = false;
            this._valid = true;
            CursorableLinkedList.this.registerCursor(this);
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object object) {
            this.checkForComod();
            Listable listable = CursorableLinkedList.this.insertListable(this._cur.prev(), this._cur.next(), object);
            this._cur.setPrev(listable);
            this._cur.setNext(listable.next());
            this._lastReturned = null;
            ++this._nextIndex;
            ++this._expectedModCount;
        }

        protected void listableRemoved(Listable listable) {
            if (null == CursorableLinkedList.this._head.prev()) {
                this._cur.setNext(null);
            } else if (this._cur.next() == listable) {
                this._cur.setNext(listable.next());
            }
            if (null == CursorableLinkedList.this._head.next()) {
                this._cur.setPrev(null);
            } else if (this._cur.prev() == listable) {
                this._cur.setPrev(listable.prev());
            }
            if (this._lastReturned == listable) {
                this._lastReturned = null;
            }
        }

        protected void listableInserted(Listable listable) {
            if (null == this._cur.next() && null == this._cur.prev()) {
                this._cur.setNext(listable);
            } else if (this._cur.prev() == listable.prev()) {
                this._cur.setNext(listable);
            }
            if (this._cur.next() == listable.next()) {
                this._cur.setPrev(listable);
            }
            if (this._lastReturned == listable) {
                this._lastReturned = null;
            }
        }

        protected void listableChanged(Listable listable) {
            if (this._lastReturned == listable) {
                this._lastReturned = null;
            }
        }

        @Override
        protected void checkForComod() {
            if (!this._valid) {
                throw new ConcurrentModificationException();
            }
        }

        protected void invalidate() {
            this._valid = false;
        }

        public void close() {
            if (this._valid) {
                this._valid = false;
                CursorableLinkedList.this.unregisterCursor(this);
            }
        }
    }

    class ListIter
    implements ListIterator {
        Listable _cur = null;
        Listable _lastReturned = null;
        int _expectedModCount;
        int _nextIndex;

        ListIter(int n) {
            this._expectedModCount = CursorableLinkedList.this._modCount;
            this._nextIndex = 0;
            if (n == 0) {
                this._cur = new Listable(null, CursorableLinkedList.this._head.next(), null);
                this._nextIndex = 0;
            } else if (n == CursorableLinkedList.this._size) {
                this._cur = new Listable(CursorableLinkedList.this._head.prev(), null, null);
                this._nextIndex = CursorableLinkedList.this._size;
            } else {
                Listable listable = CursorableLinkedList.this.getListableAt(n);
                this._cur = new Listable(listable.prev(), listable, null);
                this._nextIndex = n;
            }
        }

        public Object previous() {
            this.checkForComod();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object object = this._cur.prev().value();
            this._lastReturned = this._cur.prev();
            this._cur.setNext(this._cur.prev());
            this._cur.setPrev(this._cur.prev().prev());
            --this._nextIndex;
            return object;
        }

        @Override
        public boolean hasNext() {
            this.checkForComod();
            return null != this._cur.next() && this._cur.prev() != CursorableLinkedList.this._head.prev();
        }

        @Override
        public Object next() {
            this.checkForComod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this._cur.next().value();
            this._lastReturned = this._cur.next();
            this._cur.setPrev(this._cur.next());
            this._cur.setNext(this._cur.next().next());
            ++this._nextIndex;
            return object;
        }

        @Override
        public int previousIndex() {
            this.checkForComod();
            if (!this.hasPrevious()) {
                return -1;
            }
            return this._nextIndex - 1;
        }

        @Override
        public boolean hasPrevious() {
            this.checkForComod();
            return null != this._cur.prev() && this._cur.next() != CursorableLinkedList.this._head.next();
        }

        public void set(Object object) {
            this.checkForComod();
            try {
                this._lastReturned.setValue(object);
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalStateException();
            }
        }

        @Override
        public int nextIndex() {
            this.checkForComod();
            if (!this.hasNext()) {
                return CursorableLinkedList.this.size();
            }
            return this._nextIndex;
        }

        @Override
        public void remove() {
            this.checkForComod();
            if (null == this._lastReturned) {
                throw new IllegalStateException();
            }
            this._cur.setNext(this._lastReturned == CursorableLinkedList.this._head.prev() ? null : this._lastReturned.next());
            this._cur.setPrev(this._lastReturned == CursorableLinkedList.this._head.next() ? null : this._lastReturned.prev());
            CursorableLinkedList.this.removeListable(this._lastReturned);
            this._lastReturned = null;
            --this._nextIndex;
            ++this._expectedModCount;
        }

        public void add(Object object) {
            this.checkForComod();
            this._cur.setPrev(CursorableLinkedList.this.insertListable(this._cur.prev(), this._cur.next(), object));
            this._lastReturned = null;
            ++this._nextIndex;
            ++this._expectedModCount;
        }

        protected void checkForComod() {
            if (this._expectedModCount != CursorableLinkedList.this._modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static class Listable
    implements Serializable {
        private Listable _prev = null;
        private Listable _next = null;
        private Object _val = null;

        Listable(Listable listable, Listable listable2, Object object) {
            this._prev = listable;
            this._next = listable2;
            this._val = object;
        }

        Listable next() {
            return this._next;
        }

        Listable prev() {
            return this._prev;
        }

        Object value() {
            return this._val;
        }

        void setNext(Listable listable) {
            this._next = listable;
        }

        void setPrev(Listable listable) {
            this._prev = listable;
        }

        Object setValue(Object object) {
            Object object2 = this._val;
            this._val = object;
            return object2;
        }
    }
}

