#!/bin/sh

if [ "$1" = "-r" ] ; then
    REGEN="true"
    shift
fi
# hard-enable regeneration of configure scripts and Makefiles - workaround for JBNADM-874 (ips, 03/02/07)
REGEN="true"

if [ "$1" = "-help" -o "x$1" = "x" -o "x$2" = "x" -o \
     "$1" != "1.3" -a "$1" != "2.0" -a "$1" != "2.2" ]; then
    echo "$0 apache_version /path/to/apxs"
    echo "    Where: apache_version is 2.2, 2.0, or 1.3, and the path to apxs is"
    echo "    an absolute path to the apxs script."
    exit
fi

VERSION=$1
APXS=$2
CWD=`pwd`
APACHEDIR=`$2 -q "PREFIX"`
PERL=`which perl`

if [ -f "${CWD}/res/snmp-map.sh" ] ; then
    ${CWD}/res/snmp-map.sh
fi

if [ "x${MAKE}" = "x" ]; then
    MAKE=make
fi

# This should be -e, but that isn't portable to some built-in tests
if [ ! -f "`which ${MAKE}`" ]; then
    echo "Could not find ${MAKE} on this machine"
    exit 1
fi

if [ $? = 1 ]; then
    exit
fi

LOGFILE="${CWD}/${VERSION}_log"
FAILMSG="Build failed.  Please email ${LOGFILE} to support"

if [ -f ${LOGFILE} ]; then
    rm ${LOGFILE}
fi

chmod +x snmp1.3/src/remake_status
find . -name "configure" | xargs chmod +x
find . -name "missing" | xargs chmod +x
rm -f snmp1.3/autom4te.cache/*
rm -f snmp2.0/autom4te.cache/*
rm -f snmp_common/libsmi/autom4te.cache/*
rm -f snmp_common/sdbm/autom4te.cache/*

#### XXX
# This is a hack, but there is no good way to do this.  Basically, tar and
# ant are not very good at maintaining file permissions.  We have two scripts
# that must have execute permissions, so we just make sure they are correct.
# all other scripts will be created as a part of the build, so we don't have
# to worry about those.
find . -name "Makefile.am" | xargs touch
find . -name "Makefile.in" | xargs touch
find . -name "configure" | xargs touch
find . -name "config.cache" | xargs rm -f
find . -name "stamp-h.in" | xargs touch
find . -name "parser-smi.c" | xargs touch
find . -name "parser-sming.c" | xargs touch
find . -name "scanner-smi.c" | xargs touch
find . -name "scanner-sming.c" | xargs touch

sed -e 's/aclocal-1.6/aclocal/' snmp_common/sdbm/config.status > snmp_common/sdbm/config.status

if [ "x${REGEN}" != "x" ]; then
    echo "Generating configure scripts and Makefiles"
    echo "Preparing sdbm..."
    (cd snmp_common/sdbm && \
     aclocal && autoconf) || exit 1

    #debian has an old automake version
    if [ "x`automake --help | grep ignore-deps`" != "x" ]; then
      IGNORE_DEPS="--ignore-deps"
    fi
    # add missing if automake supports it
    if [ "x`automake --help | grep add-missing`" != "x" ]; then
      IGNORE_DEPS="$IGNORE_DEPS --add-missing"
    fi

    echo "Preparing smi..."
#    (cd snmp_common/libsmi && [ -f Makefile ] && make -i clean >/dev/null 2>&1)
    (cd snmp_common/libsmi && \
     aclocal && \
     libtoolize --copy --force && \
     automake ${IGNORE_DEPS} && autoconf) || exit 1

    echo "Preparing Apache ${VERSION}..."
    if [ ${VERSION} = "1.3" ]; then
      (cd snmp1.3 && \
       autoheader && autoconf) || exit 1
    elif [ ${VERSION} = "2.0" ] || [ ${VERSION} = "2.2" ]; then
      (cd snmp2.0 && \
       libtoolize --copy --force && \
       aclocal && autoheader && autoconf) || exit 1
    fi

    echo "Done."
fi

OS=`uname -s`
echo "system..." > ${LOGFILE}
uname -a >> ${LOGFILE}

if [ "x${OS}" = "xHP-UX" ]; then
    if [ ${VERSION} = "1.3" ]; then
        SNMP_LDFLAGS="-b"
    else
        SNMP_LDFLAGS="-Wl,-b"
    fi
    CFLAGS="${CFLAGS} +z +DAportable -DHPUX"
else
# gcc
    if [ ${VERSION} = "1.3" ]; then
        SNMP_LDFLAGS="-shared -Wl,-G"
    else
        SNMP_LDFLAGS="-Wc,-shared -Wl,-G"
    fi

    CFLAGS="${CFLAGS} -fPIC"

    if [ -f "`which gcc`" ]; then
        echo "gcc version..." >> ${LOGFILE}
        gcc -v >> "${LOGFILE}" 2>&1
    fi
fi

#record libc version info
if [ "x${OS}" = "xLinux" ]; then
    LIBC="/lib/libc.so.6"
    if [ -f ${LIBC} ]; then
        echo "${LIBC}..." >> ${LOGFILE}
        ${LIBC} >> ${LOGFILE}
    else
       echo "${LIBC}...not found!" >> ${LOGFILE}
    fi
fi

APBIN=`dirname ${APXS}`
HTTPD="${APBIN}/httpd"

if [ -f ${HTTPD} ]; then
    echo "${HTTPD} -V..." >> ${LOGFILE}
    ${HTTPD} -V >> ${LOGFILE}
fi

# build the common libraries first
# Configure/build Sdbm
echo "building sdbm"
echo "building sdbm\n===================\n" >> ${LOGFILE}
cd snmp_common/sdbm
${MAKE} clean >/dev/null 2>&1
CFLAGS=${CFLAGS} ./configure >> ${LOGFILE} 2>&1 ; \
        ${MAKE} >> ${LOGFILE} 2>&1
if [ "$?" != "0" ]; then
    echo ${FAILMSG}
    exit 1
fi
cd ../..

# Configure/build libsmi
echo "building libsmi"
echo "building libsmi\n====================\n" >> ${LOGFILE}
cd snmp_common/libsmi
${MAKE} clean >/dev/null 2>&1
CFLAGS=${CFLAGS} ./configure --disable-dependency-tracking --disable-shared >> ${LOGFILE} 2>&1 ;
     ${MAKE} >> ${LOGFILE} 2>&1
if [ "$?" != "0" ]; then
    echo ${FAILMSG}
    exit 1
fi
cd ../..

# Configure/build the mibs
echo "building mibs"
echo "building mibs\n====================\n" >> ${LOGFILE}
cd snmp_common/mibs
${MAKE} clean >/dev/null 2>&1
SMIDUMP=${CWD}/snmp_common/libsmi/tools/smidump ${MAKE} all smiv1 >> ${LOGFILE} 2>&1
if [ "$?" != "0" ]; then
    echo ${FAILMSG}
    exit 1
fi
cd ../..

echo "building ucd-snmp"
echo "building ucd-snmp\n====================\n" >> ${LOGFILE}
cd snmp_common/ucd-snmp
${MAKE} clean >/dev/null 2>&1
		CFLAGS=${CFLAGS} \
                ./configure --enable-mini-agent --without-openssl \
                --enable-pseudo-shared --disable-shared --enable-internal-md5 \
                --with-persistent-directory="${APACHEDIR}/libexec" \
                --with-mibdirs="${APACHEDIR}/libexec:$$HOME/.snmp/mibs" \
                --with-mibs="SNMPv2-MIB:SNMP-VIEW-BASED-ACM-MIB:SNMP-COMMUNITY-MIB:SNMP-FRAMEWORK-MIB:SNMP-MPD-MIB:SNMP-USER-BASED-SM-MIB:NETWORK-SERVICES-MIB:WWW-MIB:COVALENT-GENERIC-MIB:COVALENT-WWW-RESP-NOTIFY-MIB:COVALENT-APACHE-STATUS-MIB:COVALENT-APACHE-CONFIG-MIB:COVALENT-APACHE-MODULES-MIB" \
                --with-mib-modules="agentx" \
                --with-logfile="${APACHEDIR}/logs/snmpd.log" \
                --with-sys-contact="Covalent SNMP Conductor <webmaster@your.domain>" \
                --with-sys-location="Apache Server with Covalent SNMP Conductor" >> ${LOGFILE}
${MAKE} ucd-snmp-config.h >> ${LOGFILE}
${MAKE} >> ${LOGFILE} 2>&1
if [ "$?" != "0" ]; then
    echo ${FAILMSG}
    exit 1
fi
cd ../..

echo "building Apache module"
echo "building Apache module\n====================\n" >> ${LOGFILE}
if [ ${VERSION} = "1.3" ]; then
    SRC_VERSION=1.3
    # We have to run remake_status before building.  If we don't, then the build
    # will fail, because remake_status may not be able to find perl.  We solve
    # this by doing a `which perl` above.
    cd snmp${SRC_VERSION}
    ${MAKE} clean >/dev/null 2>&1
                SNMP_LDFLAGS=${SNMP_LDFLAGS} CFLAGS=${CFLAGS} \
                MAJOR_RV=1.2 \
		./configure --with-apxs=${APXS} \
                --with-ucd-snmp=${CWD}/snmp_common/ucd-snmp \
                --with-sdbm=${CWD}/snmp_common/sdbm \
                --enable-www-mib --enable-resp-notify-mib \
                --enable-nsm-mib --enable-apache-status-mib \
                --enable-apache-config-mib --enable-apache-modules-mib >> ${LOGFILE} ; \
                if [ -f src/status_codes.h ] ; then \
                    rm -f src/status_codes.h
                fi
                ${PERL} src/remake_status `${APXS} -q "INCLUDEDIR"` > src/status_codes.h ; \
                ${MAKE} >> ${LOGFILE} 2>&1
    if [ "$?" != "0" ]; then
        echo ${FAILMSG}
        exit 1
    fi
    cd ..
elif [ ${VERSION} = "2.0" ] || [ ${VERSION} = "2.2" ]; then
    SRC_VERSION=2.0
    # Check for Solaris - TODO does usage of --with-net-snmp may actually mean to disable the provided ucd-snmp ?
    if [ "x$OS" = "xSunOS" ] ; then
        NETSNMP="--with-net-snmp"
    else # Default case for Linux
        NETSNMP="--with-netsnmp"
    fi
    # We have to run remake_status before building.  If we don't, then the build
    # will fail, because remake_status may not be able to find perl.  We solve
    # this by doing a `which perl` above.
    cd snmp${SRC_VERSION}
    ${MAKE} clean >/dev/null 2>&1
                SNMP_LDFLAGS=${SNMP_LDFLAGS} CFLAGS=${CFLAGS} ./configure \
                --with-dynamic-snmp-agt="${APXS}" \
                ${NETSNMP}="${CWD}/snmp_common/ucd-snmp" \
                --with-covalent-sdbm="${CWD}/snmp_common/sdbm" \
                --enable-www-mib \
                --enable-www-extensions-mib \
                --enable-nsm-mib \
                --enable-apache-modules-mib \
                --enable-apache-server-mib \
                --enable-apache-logging-mib \
                --enable-apache-status-mib \
                --without-license >> ${LOGFILE} ; \
                if [ -f src/www-mib/http-protocol.h ] ; then \
                    rm -f src/www-mib/http-protocol.h
                fi
                ${PERL} src/www-mib/remake_http_protocol `${APXS} -q "INCLUDEDIR"` > src/www-mib/http-protocol.h ; \
                ${MAKE} >> ${LOGFILE} 2>&1
    if [ "$?" != "0" ]; then
        echo ${FAILMSG}
        exit 1
    fi
    cd ..
fi

# Create the package for people to copy to their Apache installation
if [ -d ${CWD}/snmp_module_${VERSION} ] ; then
    rm -Rf ${CWD}/snmp_module_${VERSION}
fi

cd ${CWD}
mkdir snmp_module_${VERSION}
mkdir snmp_module_${VERSION}/module
mkdir snmp_module_${VERSION}/tools
mkdir snmp_module_${VERSION}/conf
mkdir snmp_module_${VERSION}/mibs

# copy mib files
cp snmp_common/mibs/*.txt snmp_module_${VERSION}/mibs
cp snmp_common/mibs/ietf-mibs/*.txt snmp_module_${VERSION}/mibs
cp snmp_common/mibs/smiv1-mibs/*.txt snmp_module_${VERSION}/mibs

# copy config file and tools
cp conf/snmpd.conf snmp_module_${VERSION}/conf
find snmp_common/ucd-snmp/apps -type f -perm -111 -exec cp {} snmp_module_${VERSION}/tools \;

# copy the modules for Apache 1.3 or 2.x

if [ -f snmp${SRC_VERSION}/src/.libs/libsnmpcommon.so ] ; then
    SRCDIR=snmp${SRC_VERSION}/src/.libs
else
    SRCDIR=snmp${SRC_VERSION}/src
fi

cp ${SRCDIR}/libsnmp*.so snmp_module_${VERSION}/module
