/*
 * The Apache module when the apache logging MIB is used in its own subagent.
 * $Id: apache-logging-mib.c 8676 2008-01-17 23:11:17Z ispringer $
 */
/* General includes */
#include <sys/types.h>
#ifndef WIN32
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/uio.h>
#include <unistd.h>
#endif

/* Apache includes */
#include <httpd.h>
#include <http_config.h>
#include <http_log.h>
#include <apr_optional.h>

/* UCD-SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp_api.h>
#include <snmp_vars.h>
#include <snmp_debug.h>

/* module includes */
#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#include "www-mib/www-mib.h"
#include "snmpagent/logging.h"
#include "apache-logging-mib.h"

#ifdef COVALENT_APACHE_LOGGING_MIB
void
snmp_error_logging_send(const char *file, int line, int level,
                apr_status_t status, const server_rec *s,
                const request_rec *r, apr_pool_t *pool,
                const char *errstr)
{
snmpagent_log_record_t msg;

    DEBUGTRACE;
    /* Need to catch the SNMP message as these are not
     * Apache Application messages. Otherwise we will have
     * the potential of a hurricane passing by. :-))
     */
    if ((strstr(errstr, "SNMP:") != NULL) ||
        (snmpagent_logpath_is_open() < 0)) {
        DEBUGMSGTL(("covalentapacheloggingmib", "%s msg: %s",
                (snmpagent_logpath_is_open() ? "Error with log-pipe" : ""),
                errstr));
        return;
    }
    msg.type = APACHEERRORLOGGING;
    if (s) {
        msg.data.error.www_service = get_www_service_index(s);
    } else {
	msg.data.error.www_service = 0;
    }
    msg.data.error.log_level = (level & APLOG_LEVELMASK);
    strncpy(msg.data.error.log_message, errstr, MAX_SNMPADMINSTRING);
    msg.data.error.log_message[ MAX_SNMPADMINSTRING - 1 ] = '\0';

    DEBUGMSGTL(("covalentapacheloggingmib", "send logging %s\n", errstr));
    if (0 >= covalent_snmp_generic_logger(&msg)) {
        ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_NOTICE, 0, NULL,
                    "SNMP: generic logger: Could not log error-info\n");
    }
    return;
}

/*
 * Function which is specific to the apache_logging_info, but
 * common in functionality.
 */
void
update_apache_logging_mib(int type, apache_logging_info *info,
        unsigned int www_service, unsigned int log_level, char *log_message)
{ 
last_n_log_entry *last_log;
apr_time_t now;

    DEBUGTRACE;
    DEBUGMSGTL(("covalentapacheloggingmib", "%d %d %d %s\n", type, www_service, log_level, log_message));
    if (info) {
        now = apr_time_now();

        /* Update the log level table. */
        info->loglevel_info[log_level].counter++;
        info->loglevel_info[log_level].lasttime = now;
        strcpy(info->loglevel_info[log_level].lastmsg, log_message);

        /* Update the last N Table. */
        last_log = &(info->lastNTable[ info->lastNIndex++ % MAX_LASTN_LOG_MSG ]);
        last_log->www_service = www_service;
        last_log->level = log_level;
        last_log->time = now;
        strncpy(last_log->msg, log_message, MAX_SNMPADMINSTRING);

        /* Send SNMP NOTIFICATION, if ('log level' < 'log level enabled'). */
        if ((log_level < info->level) && info->enable) {
            generate_notification(type, www_service, log_level, now, log_message);
        }
    }
}
#endif /* COVALENT_APACHE_LOGGING_MIB */

