/*
 * This file implements the notifications part of
 * the COVALENT-APACHE-SERVER-MIB module.
 * $Id: notifications.c 8676 2008-01-17 23:11:17Z ispringer $
 */
/* Includes */
#include <sys/types.h>

/* Apache includes */
#include <httpd.h>
#include <http_config.h>
#include <http_log.h>
#include <mpm.h>

/* UCD-SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp_api.h>
#include <snmp_impl.h>
#include <snmp_client.h>
#include <snmp_debug.h>
#include <snmp_vars.h>
#include <agent_trap.h>

/* module includes */
#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#include "snmpcommon/snmpv2-tc.h"
#include "apache-server-mib.h"


#ifdef COVALENT_APACHE_SERVER_NOTIFICATION_GROUP

static unsigned long old_generation = 0;

void generate_ctApacheServerNotifications(CtApacheNotifications_t type);
void
generate_ctApacheServerNotifications(CtApacheNotifications_t type)
{
/* Oid definition of the Notification (last zero is type of notification). */
static oid ctApacheServerNotication_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 9, 3, 0 };
/* Oid definition of the Notification Objects */
static oid applOperStatus_oid[] = { 1, 3, 6, 1, 2, 1, 27, 1, 1, 6, 0 };
static oid ctASStartTime_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 3, 2, 3, 0 };
static oid ctASRestartTime_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 3, 2, 3, 0 };
static oid ctASGeneration_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 3, 2, 2, 0 };
/* varbind variables of the Notification Objects */
struct variable_list applOperStatus_var;
struct variable_list time_var;
struct variable_list generation_var;
unsigned long applIndex;
unsigned long applOperStatus;
unsigned long generation;
unsigned long date_n_time_length;

    DEBUGTRACE;
    applIndex = get_appl_index();
    switch (type) {
    case ctApacheServerColdStart:
        applOperStatus = 1;
        break;
    case ctApacheServerWarmStart:
    case ctApacheServerGracefullStart:
        applOperStatus = 5;
        break;
    case ctApacheServerShutdown:
        applOperStatus = 6;
        break;
    default: /* We got some unsupported type */
        return;
    }
    ctApacheServerNotication_oid[ 9 ] = type;

    /* applOperStatus */
    memset(&applOperStatus_var, 0, sizeof(applOperStatus_var));
    applOperStatus_oid[ 10 ] = applIndex;
    snmp_set_var_objid(&applOperStatus_var, applOperStatus_oid, 11);
    snmp_set_var_value(&applOperStatus_var, (u_char *)&(applOperStatus),
				sizeof(applOperStatus));
    applOperStatus_var.type = ASN_INTEGER;
    switch (type) {
    case ctApacheServerColdStart:
        applOperStatus_var.next_variable = &time_var;
        memset(&time_var, 0, sizeof(time_var));
        ctASStartTime_oid[ 10 ] = applIndex;
        snmp_set_var_objid(&time_var, ctASStartTime_oid, 11);
        date_n_time_length = snmp_time2DateAndTime(
                                get_ctApacheStartTime(), return_buf);
        snmp_set_var_value(&time_var, return_buf,
				date_n_time_length);
        time_var.type = ASN_OCTET_STR;
        break;
    case ctApacheServerWarmStart:
    case ctApacheServerGracefullStart:
        applOperStatus_var.next_variable = &time_var;
        memset(&time_var, 0, sizeof(time_var));
        ctASRestartTime_oid[ 10 ] = applIndex;
        snmp_set_var_objid(&time_var, ctASRestartTime_oid, 11);
        date_n_time_length = snmp_time2DateAndTime(ap_scoreboard_image->global
                                                   ->restart_time, return_buf);
        snmp_set_var_value(&time_var, return_buf,
				date_n_time_length);
        time_var.type = ASN_OCTET_STR;
        time_var.next_variable = &generation_var;
        memset(&generation_var, 0, sizeof(generation_var));
        ctASGeneration_oid[ 10 ] = applIndex;
        snmp_set_var_objid(&generation_var, ctASGeneration_oid, 11);
        generation = get_generation();
        snmp_set_var_value(&generation_var, (u_char *)&(generation),
                                sizeof(generation));
        generation_var.type = ASN_UNSIGNED;
        break;
    case ctApacheServerShutdown:
        break;
    default: /* We got some unsupported type */
        return;
    }
    send_enterprise_trap_vars(6, type, ctApacheServerNotication_oid,
				sizeof(ctApacheServerNotication_oid)/sizeof(oid),
							&applOperStatus_var);
}

#endif /* COVALENT_APACHE_SERVER_NOTIFICATION_GROUP */


void send_ctApacheServerColdStart_trap(void)
{
#ifdef COVALENT_APACHE_SERVER_NOTIFICATION_GROUP
    old_generation = get_generation();
    generate_ctApacheServerNotifications(ctApacheServerColdStart);
#endif
}

void send_ctApacheServerWarmStart_trap(void)
{
#ifdef COVALENT_APACHE_SERVER_NOTIFICATION_GROUP
    if (old_generation != get_generation()) {
        old_generation = get_generation();
        generate_ctApacheServerNotifications(ctApacheServerWarmStart);
    }
#endif
}

void send_ctApacheServerShutdown_trap(void)
{
#ifdef COVALENT_APACHE_SERVER_NOTIFICATION_GROUP
    generate_ctApacheServerNotifications(ctApacheServerShutdown);
#endif
}


