%define _plugindir %{_libdir}/sasl
%define _plugindir2 %{_libdir}/sasl2
%define db_version 4.3.27
%define bootstrap_cyrus_sasl 0

Summary: The Cyrus SASL library.
Name: cyrus-sasl
Version: 2.1.22
Release: 8%{?dist}
License: Freely Distributable
Group: System Environment/Libraries
# Source0 originally comes from ftp://ftp.andrew.cmu.edu/pub/cyrus-mail/, and
# make-no-dlcompat-tarball.sh removes the "dlcompat" subdirectory
# and srp plugin code and builds a new tarball.
Source0: cyrus-sasl-%{version}-nodlcompatorsrp.tar.bz2
Source4: saslauthd.init
#Source6: http://www.sleepycat.com/update/%{db_version}/db-%{db_version}.tar.gz
Source7: sasl-mechlist.c
Source8: sasl-checkpass.c
Source9: saslauthd.sysconfig
Source10: make-no-dlcompat-tarball.sh
URL: http://asg.web.cmu.edu/sasl/sasl-library.html
Requires: %{name}-lib = %{version}-%{release}
Patch5: cyrus-sasl-2.1.22-gdbm.patch
Patch6: cyrus-sasl-2.1.10-des.patch
Patch7: cyrus-sasl-2.1.20-gssapi-dynamic.patch
Patch9: cyrus-sasl-2.1.17-saslauthd1.patch
Patch10: cyrus-sasl-2.1.22-db_bundle.patch
Patch11: cyrus-sasl-2.1.18-no_rpath.patch
Patch13: cyrus-sasl-2.1.20-notgnu.patch
Patch14: cyrus-sasl-2.1.20-conflict.patch
Patch15: cyrus-sasl-2.1.20-saslauthd.conf-path.patch
Patch16: cyrus-sasl-2.1.22-builddir.patch
Patch18: cyrus-sasl-2.1.21-linksrcs.patch
Patch21: cyrus-sasl-2.1.22-no-static-deps.patch
Patch22: cyrus-sasl-2.1.21-gssapi-generic.patch
Patch23: cyrus-sasl-2.1.19-omit_realm.patch
Patch24: cyrus-sasl-2.1.21-sizes.patch
Patch25: cyrus-sasl-2.1.22-typo.patch
Patch26: cyrus-sasl-2.1.22-missing-crypt.patch
Patch27: cyrus-sasl-2.1.22-rimap.patch
Patch28: cyrus-sasl-2.1.22-ldap-timeout.patch
Patch29: cyrus-sasl-2.1.22-race.patch
Patch50: db-4.3.27-initmem.patch
Patch60: cyrus-sasl-2.1.22-gcc4.patch
Patch61: cyrus-sasl-2.1.22-sasldir.patch

#unx-buildrequires: db4
#unx-buildrequires: openssl

Buildroot: %{_tmppath}/%{name}-root
BuildPrereq: autoconf, automake, libtool, gdbm-devel, groff
BuildPrereq: krb5-devel >= 1.2.2, openssl-devel, pam-devel, pkgconfig
BuildPrereq: mysql-devel, postgresql-devel, zlib-devel
%if ! %{bootstrap_cyrus_sasl}
BuildPrereq: openldap-devel
%endif
Prereq: /sbin/ldconfig, chkconfig, /sbin/service

%description
The %{name} package contains the Cyrus implementation of SASL.
SASL is the Simple Authentication and Security Layer, a method for
adding authentication support to connection-based protocols.

%package lib
Group: System Environment/Libraries
Summary: Shared libraries needed by applications which use Cyrus SASL.

%description lib
The %{name}-lib package contains shared libraries which are needed by
applications which use the Cyrus SASL library.

%package devel
Requires: %{name}-lib = %{version}-%{release}
Group: Development/Libraries
Summary: Files needed for developing applications with Cyrus SASL.

%description devel
The %{name}-devel package contains files needed for developing and
compiling applications which use the Cyrus SASL library.

%package gssapi
Requires: %{name}-lib = %{version}-%{release}
Group: System Environment/Libraries
Summary: GSSAPI support for Cyrus SASL.

%description gssapi
The %{name}-gssapi package contains the Cyrus SASL plugins which
support GSSAPI authentication. GSSAPI is commonly used for Kerberos
authentication.

%package plain
Requires: %{name}-lib = %{version}-%{release}
Group: System Environment/Libraries
Summary: PLAIN and LOGIN support for Cyrus SASL.

%description plain
The %{name}-plain package contains the Cyrus SASL plugins which support
PLAIN and LOGIN authentication schemes.

%package md5
Requires: %{name}-lib = %{version}-%{release}
Group: System Environment/Libraries
Summary: CRAM-MD5 and DIGEST-MD5 support for Cyrus SASL.

%description md5
The %{name}-md5 package contains the Cyrus SASL plugins which support
CRAM-MD5 and DIGEST-MD5 authentication schemes.

%package ntlm
Requires: %{name}-lib = %{version}-%{release}
Group: System Environment/Libraries
Summary: NTLM support for Cyrus SASL.

%description ntlm
The %{name}-ntlm package contains the Cyrus SASL plugin which supports
the NTLM authentication schemes.

# This would more appropriately be named cyrus-sasl-auxprop-sql.
%package sql
Requires: %{name}-lib = %{version}-%{release}
Group: System Environment/Libraries
Summary: SQL auxprop support for Cyrus SASL.

%description sql
The %{name}-sql package contains the Cyrus SASL plugin which supports
using a RDBMS for storing shared secrets.

# This was *almost* named cyrus-sasl-auxprop-ldapdb, but that's a lot of typing.
%package ldap
Requires: %{name}-lib = %{version}-%{release}
Group: System Environment/Libraries
Summary: LDAP auxprop support for Cyrus SASL.

%description ldap
The %{name}-ldap package contains the Cyrus SASL plugin which supports using
a directory server, accessed using LDAP, for storing shared secrets.

%prep
%setup -q -a 6

# Disabled for Brew.
# We use db dependency
# pushd db-%{db_version}
# %patch50 -p2 -b .initmem
# popd

# %patch5 -p1 -b .gdbm
%patch6 -p1 -b .des
%patch7 -p1 -b .gssapi-dynamic
#%patch9 -p1 -b .saslauthd1
%patch10 -p1 -b .db_bundle
%patch11 -p1 -b .no_rpath
%patch13 -p1 -b .notgnu
%patch14 -p1 -b .conflict
%patch15 -p1 -b .path
%patch16 -p1 -b .builddir
%patch18 -p1 -b .linksrcs
# %patch21 -p1 -b .no-static-deps
%patch22 -p1 -b .gssapi-generic
#%patch23 -p1 -b .omit_realm
%patch24 -p1 -b .sizes
%patch25 -p1 -b .typo
%patch26 -p1 -b .crypt
%patch27 -p1 -b .rimap
%patch28 -p1 -b .ldap-timeout
%patch29 -p1 -b .race

%patch60 -p1 -b .gcc4
%patch61 -p1 -b .sasldir

# FIXME - this is just weird
rm config/ltconfig config/libtool.m4
rm -fr autom4te.cache
libtoolize -f -c
aclocal -I config -I cmulocal
automake -a -c -f
autoheader
autoconf -f

pushd saslauthd
# FIXME - this is just weird
rm config/ltconfig
rm -fr autom4te.cache
libtoolize -f -c
aclocal -I config -I ../cmulocal -I ../config
automake -a -c -f
autoheader
autoconf -f
popd

mkdir build-static build-shared
ln -s ../configure build-static
ln -s ../configure build-shared

%build
CFLAGS="$RPM_OPT_FLAGS -fPIC"; export CFLAGS

# Bundling copy of Berkeley DB, for sasldb support.
topdir=`pwd`
pushd db-%{db_version}/build_unix
../dist/configure \
	--with-mutex=UNIX/fcntl --disable-shared --enable-static --with-pic \
	--with-uniquename=_cyrus_sasl_sasldb_rh \
	--prefix=${topdir}/db-instroot \
	--includedir=${topdir}/db-instroot/include \
	--libdir=${topdir}/db-instroot/lib
make
make install
popd

# Find Kerberos.
krb5_prefix=`krb5-config --prefix`
if test x$krb5_prefix = x%{_prefix} ; then
	krb5_prefix=
else
	CPPFLAGS="-I${krb5_prefix}/include"; export CPPFLAGS
	CFLAGS="-I${krb5_prefix}/include $CFLAGS"
	LDFLAGS="-L${krb5_prefix}/%{_lib}"; export LDFLAGS
fi
LIBS="-lcrypt"; export LIBS
if pkg-config openssl ; then
	CPPFLAGS="`pkg-config --cflags-only-I openssl` $CPPFLAGS"; export CPPFLAGS
	CFLAGS="`pkg-config --cflags openssl` $CFLAGS"; export CFLAGS
	LDFLAGS="`pkg-config --libs-only-L openssl` $LDFLAGS"; export LDFLAGS
fi

# Find the SQL libraries used needed by the SQL auxprop plugin.
mysql_config=mysql_config
pg_config=pg_config
SQL_CFLAGS=`${mysql_config} --cflags`" -I"`${pg_config} --includedir`
SQL_LIBS=`${mysql_config} --libs`" -L"`${pg_config} --libdir`" -lpq"
SQL_CFLAGS=`eval echo "$SQL_CFLAGS" | sed -e 's,-I%{_includedir}[^/],,g' -e 's,-I%{_includedir}$,,g' -e 's,[[:blank:]]+, ,g'`
SQL_LIBS=`eval echo "$SQL_LIBS" | sed -e 's,-L%{_libdir}[^/],,g' -e 's,-L%{_libdir}$,,g' -e 's,[[:blank:]]+, ,g'`
SQL_LDFLAGS=`eval echo "$SQL_LIBS" | sed -e 's,-[^L][^ ]*,,g'`
echo $SQL_LDFLAGS
SQL_LIBS=`eval echo "$SQL_LIBS" | sed -e 's,-[^l][^ ]*,,g'`
echo $SQL_LIBS

cleanup_flags() {
	sed -r -e 's,-D_GNU_SOURCE(=[^[:blank:]]+)?,,g' \
	       -e 's,-D_FILE_OFFSET_BITS=[[:digit:]]+,,g' \
	       -e 's,-D_LARGEFILE_SOURCE(=[^[:blank:]]+)?,,g' \
	       -e 's,[[:blank:]]+, ,g'
}
CFLAGS=`echo $CFLAGS $SQL_CFLAGS | cleanup_flags`; export CFLAGS
CPPFLAGS=`echo $CPPFLAGS $SQL_CFLAGS | cleanup_flags`; export CPPFLAGS
LDFLAGS=`echo $LDFLAGS $SQL_LDFLAGS | cleanup_flags`; export LDFLAGS

build() {
pushd build-$1
shift
%configure \
	--enable-shared --enable-static \
	--disable-java \
	--with-plugindir=%{_plugindir2} \
	--with-configdir=%{_plugindir2}:%{_sysconfdir}/sasl2 \
	--disable-krb4 \
	--enable-gssapi${krb5_prefix:+=${krb5_prefix}} \
	--with-gss_impl=mit \
	--with-rc4 \
	--with-dblib=berkeley \
	--with-bdb-incdir=${topdir}/db-instroot/include \
	--with-bdb-libdir=${topdir}/db-instroot/lib \
	--with-saslauthd=/var/run/saslauthd --without-pwcheck \
	--with-ldap \
	--with-devrandom=/dev/urandom \
	--enable-anon \
	--enable-cram \
	--enable-digest \
	--enable-ntlm \
	--enable-plain \
	--enable-login \
	--disable-otp \
	--enable-ldapdb \
	--enable-sql --with-mysql=%{_prefix} --with-pgsql=%{_prefix} \
	--without-sqlite \
	"$@"
	# --enable-auth-sasldb -- EXPERIMENTAL
make sasldir=%{_plugindir2}
make -C saslauthd testsaslauthd
make -C sample
popd
}

# Build the static library without sql or ldapdb auxprop support.  Hopefully
# the only users of the static library will be clients, which don't use auxprop
# functionality anyway.
build static --enable-static --disable-ldapdb --disable-shared --disable-sql
# Build the shared library with all that good stuff.
build shared --enable-static --enable-shared

# Merge our static libdb in with libsasl, because we won't be installing it.
pushd build-static/lib
ar x ${topdir}/db-instroot/lib/libdb.a
ar cru libsasl2.a `ar t ${topdir}/db-instroot/lib/libdb.a`
tagname=CC ../libtool --mode=link %{__cc} -o sasl2-static-mechlist -I../../include $CFLAGS $RPM_SOURCE_DIR/sasl-mechlist.c $LDFLAGS ./libsasl2.la
popd

# Build small programs to list the available mechanisms, because I need them.
pushd build-shared/lib
tagname=CC ../libtool --mode=link %{__cc} -o sasl2-shared-mechlist -I../../include $CFLAGS $RPM_SOURCE_DIR/sasl-mechlist.c $LDFLAGS ./libsasl2.la
popd

%install
test "$RPM_BUILD_ROOT" != "/" && rm -rf $RPM_BUILD_ROOT

pushd build-shared
make install DESTDIR=$RPM_BUILD_ROOT sasldir=%{_plugindir2}
cd ../build-static
make install DESTDIR=$RPM_BUILD_ROOT sasldir=%{_plugindir2}
cd ../build-shared
make install DESTDIR=$RPM_BUILD_ROOT sasldir=%{_plugindir2} -C plugins
make install DESTDIR=$RPM_BUILD_ROOT sasldir=%{_plugindir2} -C utils
install -m755 -d $RPM_BUILD_ROOT%{_bindir}

libtool --mode=install \
install -m755 sample/client $RPM_BUILD_ROOT%{_bindir}/sasl2-sample-client
libtool --mode=install \
install -m755 sample/server $RPM_BUILD_ROOT%{_bindir}/sasl2-sample-server
libtool --mode=install \
install -m755 saslauthd/testsaslauthd $RPM_BUILD_ROOT%{_sbindir}/testsaslauthd
libtool --mode=install \
install -m755 utils/dbconverter-2 $RPM_BUILD_ROOT%{_sbindir}/dbconverter-2

# Install the saslauthd mdoc page in the expected location.  Sure, it's not
# really a man page, but groff seems to be able to cope with it.
install -m755 -d $RPM_BUILD_ROOT%{_mandir}/man8/
install -m644 ../saslauthd/saslauthd.mdoc $RPM_BUILD_ROOT%{_mandir}/man8/saslauthd.8
popd

# Create the saslauthd listening directory.
install -m755 -d $RPM_BUILD_ROOT/var/run/saslauthd

# Install the init script.
install -m755 -d $RPM_BUILD_ROOT/etc/rc.d/init.d $RPM_BUILD_ROOT/etc/sysconfig
install -m755 $RPM_SOURCE_DIR/saslauthd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/saslauthd
install -m644 $RPM_SOURCE_DIR/saslauthd.sysconfig $RPM_BUILD_ROOT/etc/sysconfig/saslauthd

# Install the config dirs if they're not already there.
install -m755 -d $RPM_BUILD_ROOT/%{_sysconfdir}/sasl2
install -m755 -d $RPM_BUILD_ROOT/%{_plugindir2}

# Provide an easy way to query the list of available mechanisms.
libtool --mode=install \
install -m755 build-static/lib/sasl2-static-mechlist \
$RPM_BUILD_ROOT%{_sbindir}/
libtool --mode=install \
install -m755 build-shared/lib/sasl2-shared-mechlist \
$RPM_BUILD_ROOT%{_sbindir}/

# Remove unpackaged files from the buildroot.
rm -f $RPM_BUILD_ROOT%{_libdir}/sasl2/libotp.*
rm -f $RPM_BUILD_ROOT%{_libdir}/sasl2/*.a
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_mandir}/cat8/saslauthd.8

%clean
test "$RPM_BUILD_ROOT" != "/" && rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add saslauthd

%preun
if [ $1 -eq 0 ] ; then
	/sbin/chkconfig --del saslauthd
fi

%postun
if [ $1 -ne 0 ] ; then
	/sbin/service saslauthd condrestart 2>&1 > /dev/null
fi

%post lib -p /sbin/ldconfig
%postun lib -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc saslauthd/LDAP_SASLAUTHD
%dir %{_plugindir2}/
%{_plugindir2}/*sasldb*.so*
%{_plugindir2}/*sasldb*.la
%{_mandir}/man8/*
%{_sbindir}/dbconverter-2
%{_sbindir}/pluginviewer
%{_sbindir}/saslpasswd2
%{_sbindir}/sasldblistusers2
%{_sbindir}/saslauthd
%{_sbindir}/testsaslauthd
%config(noreplace) /etc/sysconfig/saslauthd
%config /etc/rc.d/init.d/saslauthd
/var/run/saslauthd

%files lib
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README doc/*.html
%{_libdir}/libsasl*.so.*
%dir %{_sysconfdir}/sasl2
%dir %{_plugindir2}/
%{_plugindir2}/*anonymous*.so*
%{_plugindir2}/*anonymous*.la

%files plain
%defattr(-,root,root)
%{_plugindir2}/*plain*.so*
%{_plugindir2}/*plain*.la
%{_plugindir2}/*login*.so*
%{_plugindir2}/*login*.la

%files ldap
%defattr(-,root,root)
%{_plugindir2}/*ldapdb*.so*
%{_plugindir2}/*ldapdb*.la

%files md5
%defattr(-,root,root)
%{_plugindir2}/*crammd5*.so*
%{_plugindir2}/*crammd5*.la
%{_plugindir2}/*digestmd5*.so*
%{_plugindir2}/*digestmd5*.la

%files ntlm
%defattr(-,root,root)
%{_plugindir2}/*ntlm*.so*
%{_plugindir2}/*ntlm*.la

%files sql
%defattr(-,root,root)
%{_plugindir2}/*sql*.so*
%{_plugindir2}/*sql*.la

%files gssapi
%defattr(-,root,root)
%{_plugindir2}/*gssapi*.so*
%{_plugindir2}/*gssapi*.la

%files devel
%defattr(-,root,root)
%doc doc/*.txt
%{_bindir}/sasl2-sample-client
%{_bindir}/sasl2-sample-server
%{_includedir}/*
%{_libdir}/libsasl*.a
%{_libdir}/libsasl*.*so
%{_mandir}/man3/*
%{_sbindir}/sasl2-static-mechlist
%{_sbindir}/sasl2-shared-mechlist

%changelog
* Tue Sep  4 2012 Mladen Turk <mturk@redhat.com> 2.1.22-8
- Rebuild

* Wed Feb 24 2010 Jan F. Chadima <jchadima@redhat.com> - 2.1.22-6
- solve race condition (#560532)

* Tue Apr 28 2009 Tomas Mraz <tmraz@redhat.com> 2.1.22-5
- install the shared version of pluginviewer and other tools (#473197)
- remove potentially patented srp plugin which was not built
  anyway (#368421)
- include crypt.h for missing prototype (#433583)
- implement reload as conditional restart in the init script (#448154)
- set the LDAP_OPT_TIMEOUT in the ldap plugin (#475726)

* Fri Sep 29 2006 Nalin Dahyabhai <nalin@redhat.com> 2.1.22-4
- rebuild without 'dlcompat' bits (#206119)

* Mon Jul 17 2006 Nalin Dahyabhai <nalin@redhat.com> 2.1.22-3
- rebuild

* Tue Jun 20 2006 Nalin Dahyabhai <nalin@redhat.com> 2.1.22-2
- fix a typo in sasl_client_start(3) (#196066)

* Mon May 22 2006 Nalin Dahyabhai <nalin@redhat.com> 2.1.22-1
- update to 2.1.22, adding pluginviewer to %%{_sbindir}

* Tue May 16 2006 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-12
- add conditionalized build dependency on openldap-devel (#191855)
- patch md5global.h to be the same on all architectures

* Thu Apr 27 2006 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-11
- add unapplied patch which makes the DIGEST-MD5 plugin omit the realm
  argument when the environment has $CYRUS_SASL_DIGEST_MD5_OMIT_REALM set to a
  non-zero value, for testing purposes
- add missing buildrequires on zlib-devel (#190113)

* Mon Feb 20 2006 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-10
- add missing buildrequires on gdbm-devel (Karsten Hopp)

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 2.1.21-9.2
- bump again for double-long bug on ppc(64)

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - 2.1.21-9.1
- rebuilt for new gcc4.1 snapshot and glibc changes

* Mon Dec 19 2005 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-9
- use --as-needed to avoid linking dbconverter-2 with SQL libraries, which
  it doesn't use because it manipulates files directly (#173321)

* Fri Dec 09 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt

* Mon Nov 14 2005 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-8
- rebuild with new OpenLDAP, overriding the version checks to assume that
  2.3.11 is acceptable
- remove a lingering patch for 1.x which we no longer use

* Sat Nov 12 2005 Tom Lane <tgl@redhat.com> 2.1.21-7
- Rebuild due to mysql update.

* Tue Nov  8 2005 Tomas Mraz <tmraz@redhat.com> 2.1.21-6
- rebuilt with new openssl

* Fri Sep  9 2005 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-5
- add missing buildrequires: on groff (#163032)

* Thu Sep  1 2005 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-4
- move the ldapdb auxprop support into a subpackage (#167300)
  (note: the ldap password check support in saslauthd doesn't use auxprop)

* Tue Aug 30 2005 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-3
- correct a use of uninitialized memory in the bundled libdb (Arjan van de Ven)

* Mon Aug 29 2005 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-2
- move the ANONYMOUS mech plugin to the -lib subpackage so that multilib
  systems can use it without installing the main package
- build the static libraries without sql auxprop support

* Mon Aug 29 2005 Nalin Dahyabhai <nalin@redhat.com> 2.1.21-1
- update to 2.1.21
- turn off compilation of libsasl v1 (finally)
- explicitly disable sqlite to avoid the build warning
- change the default mechanism which is set for saslauthd from "shadow" to
  "pam" (#159194)
- split the shared library up from saslauthd so that multilib systems don't
  have to pull in every dependency of saslauthd for the compat arch (#166749)

* Wed Apr 13 2005 Nalin Dahyabhai <nalin@redhat.com> 2.1.20-5
- rebuild with new deps

* Tue Mar  1 2005 Nalin Dahyabhai <nalin@redhat.com> 2.1.20-4
- rebuild with new deps

* Thu Nov 11 2004 Jeff Johnson <jbj@jbj.org> 2.1.20-3
- rebuild against db-4.3.21.

* Thu Nov 11 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.20-2
- build with mysql-devel instead of mysqlclient10

* Mon Nov  1 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.20-1
- build with mysqlclient10 instead of mysql-devel

* Wed Oct 27 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.20-0
- update to 2.1.20, including the fix for CAN-2004-0884

* Thu Oct  5 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.19-3
- use notting's fix for incorrect patch for CAN-2004-0884 for 1.5.28

* Thu Oct  5 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.19-2
- don't trust the environment in setuid/setgid contexts (CAN-2004-0884, #134660)

* Thu Aug 19 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.19-1
- rebuild (the 2.1.19 changelog for fixing a buffer overflow referred to a CVS
  revision between 2.1.18 and 2.1.19)

* Mon Jul 19 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.19-0
- update to 2.1.19, maybe for update

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Jun  7 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.18-4
- enable sql auxprop support in a subpackage
- include LDAP_SASLAUTHD documentation file (#124830)

* Fri Jun  4 2004 Nalin Dahyabhai <nalin@redhat.com>
- turn on ntlm in a subpackage

* Thu May 13 2004 Thomas Woerner <twoerner@redhat.com> 2.1.18-3
- removed rpath

* Tue Mar 16 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.18-2
- turn on building of libsasl v1 again

* Fri Mar 12 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.18-1
- update to 2.1.18
- saslauthd's ldap code is no longer marked experimental, so we build it

* Mon Mar  8 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.17-4
- rebuild

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Feb  3 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.17-2
- include default /etc/sysconfig/saslauthd configuration file for the init
  script (#114868)

* Thu Jan 29 2004 Nalin Dahyabhai <nalin@redhat.com>
- drop saslauthd_version patch for libsasl2

* Thu Jan 29 2004 Nalin Dahyabhai <nalin@redhat.com>
- add a saslauthd_version option to libsasl's saslauthd client and teach it to
  do the right thing
- enable the saslauthd client code in libsasl version 1 (it's still going away!)
- add saslauthd1-checkpass/saslauthd2-checkpass for testing the above change

* Wed Jan  7 2004 Nalin Dahyabhai <nalin@redhat.com> 2.1.17-1
- forcibly disable otp and sql plugins at compile-time

* Fri Dec 19 2003 Nalin Dahyabhai <nalin@redhat.com>
- update to 2.1.17, forcing the gssapi plugin to be shared now, as before
- use a bundled libdb (#112215)
- build static-with-all-plugins and normal-shared libsasl versions
- add sasl2-{shared,static}-mechlist for very basic sanity checking
- make inclusion of sasl1 stuffs conditional, because it's so going away

* Sat Dec 13 2003 Jeff Johnson <jbj@jbj.org> 2.1.15-7
- rebuild against db-4.2.52.

* Thu Oct 23 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-6
- use /dev/urandom instead of /dev/random for SASL2 (docs indicate that this is
  safe if you aren't using OTP or SRP, and we build neither); SASL1 appears to
  use it to seed the libc RNG only (#103378)

* Mon Oct 20 2003 Nalin Dahyabhai <nalin@redhat.com>
- obey RPM_OPT_FLAGS again when krb5_prefix != %%{_prefix}

* Fri Oct 17 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-5
- install saslauthd's mdoc page instead of the pre-formatted man page, which
  would get formatted again

* Thu Sep 25 2003 Jeff Johnson <jbj@jbj.org> 2.1.15-5
- rebuild against db-4.2.42.

* Mon Sep 15 2003 Nalin Dahyabhai <nalin@redhat.com>
- include testsaslauthd
- note in the README that the saslauthd protocol is different for v1 and v2,
  so v1's clients can't talk to the v2 server

* Thu Aug 21 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-4
- rebuild

* Thu Aug 21 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-3
- add logic to build with gssapi libs in either /usr or /usr/kerberos

* Mon Jul 21 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-2
- rebuild

* Tue Jul 15 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.15-1
- update to 2.1.15

* Mon Jul 14 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.14-1
- update to 2.1.14

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri May  9 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.13-3
- change -m argument to saslauthd to be a directory instead of a path

* Thu May  8 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.13-2
- link libsasl2 with -lpthread to ensure that the sasldb plug-in can always
  be loaded

* Tue Apr 29 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.13-1
- update to 2.1.13

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Tue Jan  7 2003 Nalin Dahyabhai <nalin@redhat.com> 2.1.10-3
- rebuild

* Thu Dec 12 2002 Nalin Dahyabhai <nalin@redhat.com>
- consider either des_cbc_encrypt or DES_cbc_encrypt to be sufficient when
  searching for a DES implementation in libcrypto
- pull in CPPFLAGS and LDFLAGS from openssl's pkg-config data, if it exists

* Mon Dec  9 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.10-2
- rebuild

* Mon Dec  9 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.10-1
- update to 2.1.10, fixing buffer overflows in libsasl2 noted by Timo Sirainen

* Tue Nov 12 2002 Tim Powers <timp@redhat.com> 2.1.7-5
- remove files from $RPM_BUILD_ROOT that we don't intend to include

* Tue Oct  9 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.7-4
- update to SASLv1 to final 1.5.28

* Fri Sep 13 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.7-3
- rebuild, overriding sasldir when running make so that on multilib systems
  applications will be able to load modules for the right arch

* Mon Sep  2 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.7-2
- include dbconverter-2 (#68741)

* Fri Aug  9 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.7-1
- update to 2.1.7, fixing a race condition in digest-md5

* Wed Jul 17 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.6-1
- update to 2.1.6 and 1.5.28

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu Jun 13 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.5-1
- update to 2.1.5

* Mon Jun 10 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.4-1
- update to 2.1.4

* Sun May 26 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 16 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.2-1
- modify to build with db 4.x

* Thu Apr 18 2002 Nalin Dahyabhai <nalin@redhat.com>
- update cyrus-sasl 2 to 2.1.2
- change buildreq to db3-devel

* Tue Feb 12 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.1-3
- suppress output to stdout/stderr in %%postun

* Sun Feb 10 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.1-2
- configure sasldb2 to use berkeley DB instead of gdbm

* Wed Feb  6 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.1-1
- update to 2.1.1

* Thu Jan 31 2002 Nalin Dahyabhai <nalin@redhat.com> 2.1.0-1
- marge 1.5.24 back in, making a note that it should be removed at some
  point in the future

* Wed Jan 30 2002 Nalin Dahyabhai <nalin@redhat.com>
- update to 2.1.0, which is designed to be installed in parallel with cyrus sasl
  1.x, so fork the package and rename it to cyrus-sasl2
- add the sasldb auxprop plugin to the main package
- add disabled-by-default saslauthd init script
- move the .la files for plugins into their respective packages -- they're
  needed by the library

* Wed Jan 23 2002 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-24
- free ride through the build system

* Fri Nov  2 2001 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-23
- patch to fix possible syslog format-string vulnerability 

* Mon Oct 29 2001 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-22
- add pam-devel as a buildprereq

* Wed Aug 29 2001 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-21
- include sample programs in the -devel subpackage, prefixing their names
  with "sasl-" to reduce future potential naming conflicts

* Tue Aug 14 2001 Nalin Dahyabhai <nalin@redhat.com> 1.5.24-20
- build without -ggdb

* Fri Aug  3 2001 Nalin Dahyabhai <nalin@redhat.com>
- add gdbm-devel as a build dependency (#44990)
- split off CRAM-MD5 and DIGEST-MD5 into a subpackage of their own (#43079,
  and dialogs with David L. Parsley)

* Fri Apr 27 2001 Nalin Dahyabhai <nalin@redhat.com>
- split out the PLAIN and LOGIN mechanisms into their own package (this allows
  an administrator to disable them by simply removing the package)

* Fri Jan 19 2001 Nalin Dahyabhai <nalin@redhat.com>
- rebuild in new environment

* Wed Dec  6 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix gssapi-over-tls

* Fri Oct 27 2000 Nalin Dahyabhai <nalin@redhat.com>
- enable static libraries, but always build with -fPIC

* Wed Oct 25 2000 Nalin Dahyabhai <nalin@redhat.com>
- make sure the version of 1.5.24 in the package matches the masters (#18968)

* Mon Oct  9 2000 Nalin Dahyabhai <nalin@redhat.com>
- re-add the libsasl.so symlink to the -devel package (oops)

* Fri Oct  6 2000 Nalin Dahyabhai <nalin@redhat.com>
- move .so files for modules to their respective packages -- they're not -devel
  links meant for use by ld anyway

* Thu Oct  5 2000 Nalin Dahyabhai <nalin@redhat.com>
- split off -devel subpackage
- add a -gssapi subpackage for the gssapi plugins

* Wed Aug 16 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix the summary text

* Sun Aug 13 2000 Nalin Dahyabhai <nalin@redhat.com>
- re-enable arcfour and CRAM

* Fri Aug  4 2000 Nalin Dahyabhai <nalin@redhat.com>
- force use of gdbm for database files to avoid DB migration weirdness
- enable login mechanism
- disable gssapi until it can coexist peacefully with non-gssapi setups
- actually do a make in the build section (#15410)

* Fri Jul 21 2000 Nalin Dahyabhai <nalin@redhat.com>
- update to 1.5.24

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jun 27 2000 Nalin Dahyabhai <nalin@redhat.com>
- rebuild in new environment (release 3)

* Mon Jun 19 2000 Nalin Dahyabhai <nalin@redhat.com>
- don't muck with syslogd in post
- remove patch for db-3.0 wackiness, no longer needed

* Thu Jun  8 2000 Nalin Dahyabhai <nalin@redhat.com>
- FHS cleanup
- don't strip anything by default

* Fri Feb 11 2000 Tim Powers <timp@redhat.com>
- fixed man pages not being gzipped

* Tue Nov 16 1999 Tim Powers <timp@redhat.com>
- incorporated changes from Mads Kiilerich
- release number is 1, not mk1

* Tue Nov 10 1999 Mads Kiilerich <mads@kiilerich.com>
- updated to sasl 1.5.11
- configure --disable-krb4 --without-rc4 --disable-cram 
  because of missing libraries and pine having cram as default...
- handle changing libsasl.so versions

* Mon Aug 30 1999 Tim Powers <timp@redhat.com>
- changed group

* Fri Aug 13 1999 Tim Powers <timp@redhat.com>
- first build for Powertools
