<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1437838 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_heartbeat.xml.meta">

<name>mod_heartbeat</name>
<description>Envoie des messages d'&eacute;tat au mandataire frontal</description>
<status>Experimental</status>
<sourcefile>mod_heartbeat</sourcefile>
<identifier>heartbeat_module</identifier>
<compatibility>Disponible &agrave; partir de la version 2.3
du serveur HTTP Apache</compatibility>

<summary>
    <p><module>mod_heartbeat</module> envoie &agrave; un moniteur
    <module>mod_heartmonitor</module> des messages multicast l'informant
    du nombre de connexions courantes. En g&eacute;n&eacute;ral,
    <module>mod_heartmonitor</module> est charg&eacute; sur un serveur
    mandataire o&ugrave; <module>mod_lbmethod_heartbeat</module> est charg&eacute;, ce
    qui permet d'utiliser la <em>lbmethod</em> "heartbeat" au sein des
    directives <directive module="mod_proxy">ProxyPass</directive>.</p>

    <p>
    Le module <module>mod_heartbeat</module> est charg&eacute; sur le
    serveur d'origine qui sert les requ&ecirc;tes via le
    serveur mandataire.
</p>

    <note type="warning">
        Pour utiliser <module>mod_heartbeat</module>,
	<module>mod_status</module> et <module>mod_watchdog</module>
	doivent &ecirc;tre soit des modules statiques, soit des modules
	dynamiques, et dans ce dernier cas, ils doivent &ecirc;tre charg&eacute;s
	avant <module>mod_heartbeat</module>.
    </note>

</summary>

<section id="consuming">
    <title>Utilisation de la sortie de mod_heartbeat</title>
  <p>
      Chaque seconde, ce module g&eacute;n&egrave;re un paquet multicast UDP contenant
      le nombre de threads/processus occup&eacute;s et en attente. Le paquet
      poss&egrave;de un format ASCII simple similaire aux param&egrave;tres de requ&ecirc;te
      GET en HTTP.
  </p>

<example><title>Exemple de paquet</title>
v=1&amp;ready=75&amp;busy=0
</example>

  <p>
    Les utilisateurs disposeront dans le futur de nouvelles variables en
    plus de busy et ready, et toujours s&eacute;par&eacute;es par des '&amp;'.
  </p>

</section>

<directivesynopsis>
<name>HeartbeatAddress</name>
<description>Adresse multicast &agrave; laquelle envoyer les requ&ecirc;tes
heartbeat</description>
<syntax>HeartbeatAddress <var>addr:port</var></syntax>
<default>disabled</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>HeartbeatAddress</directive> permet de
    sp&eacute;cifier l'adresse multicast &agrave; laquelle <module>mod_heartbeat</module> va
    envoyer ses informations. En g&eacute;n&eacute;ral, cette adresse correspond &agrave; la
    valeur d&eacute;finie par la directive  <directive
    module="mod_heartmonitor">HeartbeatListen</directive> sur le serveur
    mandataire frontal.</p>
    <highlight language="config">
	HeartbeatAddress 239.0.0.1:27999
    </highlight>
</usage>
</directivesynopsis>

</modulesynopsis>
