<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1338147 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="avoid.xml.meta">
  <parentdocument href="./">Rewrite</parentdocument>

<title>Advanced Techniques with mod_rewrite</title>

<summary>

<p>Ce document compl&egrave;te la <a
    href="../mod/mod_rewrite.html">documentation de r&eacute;f&eacute;rence</a> du
    module <module>mod_rewrite</module>. Il pr&eacute;sente un certain nombre
    de techniques avanc&eacute;es quant &agrave;
    l'utilisation de mod_rewrite.</p>

<note type="warning">Notez que la plupart des exemples ne fonctionneront
pas en l'&eacute;tat dans la configuration particuli&egrave;re de votre serveur ; il
est donc important de bien comprendre leur fonctionnement, plut&ocirc;t que de
simplement les copier/coller dans votre configuration.</note>

</summary>
<seealso><a href="../mod/mod_rewrite.html">Documentation du module</a></seealso>
<seealso><a href="intro.html">Introduction &agrave; mod_rewrite</a></seealso>
<seealso><a href="remapping.html">Redirection et remise en
correspondance</a></seealso>
<seealso><a href="access.html">Contr&ocirc;ler l'acc&egrave;s</a></seealso>
<seealso><a href="vhosts.html">serveurs virtuels</a></seealso>
<seealso><a href="proxy.html">serveurs mandataires</a></seealso>
<seealso><a href="rewritemap.html">Utilisation de RewriteMap</a></seealso>
<!--<seealso><a href="advanced.html">Techniques avanc&eacute;es</a></seealso>-->
<seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>

<section id="sharding">

  <title>Distribution de la charge entre plusieurs serveurs
  d'arri&egrave;re-plan en fonction de l'adresse IP</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>La fragmentation ou "sharding" est une technique courante de
      distribution de la charge du serveur ou de l'espace de stockage.
      Quand on utilise cette m&eacute;thode, un serveur frontal utilise l'URL
      pour r&eacute;partir de mani&egrave;re appropri&eacute;e les utilisateurs et objets
      entre diff&eacute;rents serveurs d'arri&egrave;re-plan.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>On maintient une table de correspondance entre utilisateurs et
      serveurs cibles dans des fichiers externes. Ces derniers se
      pr&eacute;sentent comme suit :</p>

<example>
utilisateur1  serveur_physique_utilisateur1<br />
utilisateur2  serveur_physique_utilisateur2<br />
:      :
</example>

  <p>Tout ceci est enregistr&eacute; dans un fichier
  <code>correspondances-utilisateurs-serveurs</code>. Le but est de
  faire correspondre</p>

<example>
/u/utilisateur1/chemin
</example>

  <p>avec</p>

<example>
http://serveur_physique_utilisateur1/u/utilisateur/chemin
</example>

      <p>il n'est ainsi pas n&eacute;cessaire que tous les chemins URL soient
      valides sur tous les serveurs physiques d'arri&egrave;re-plan. Le jeu de
      r&egrave;gles suivant fait tout ceci pour nous, en s'appuyant sur les
      fichiers de correspondances, en supposant que serveur0 est un
      serveur par d&eacute;faut qui sera utilis&eacute; lorsqu'un utilisateur ne
      poss&egrave;dera pas d'entr&eacute;e dans la table de correspondances :</p>

<highlight language="config">
RewriteEngine on
RewriteMap      users-to-hosts   txt:/path/to/map.users-to-hosts
RewriteRule   ^/u/([^/]+)/?(.*)   http://${users-to-hosts:$1|server0}/u/$1/$2
</highlight>
    </dd>
  </dl>

  <p>Voir la documentation de <directive
  module="mod_rewrite">RewriteMap</directive> pour une description plus
  approfondie de la syntaxe de cette directive.</p>

</section>

<section id="on-the-fly-content">

  <title>R&eacute;g&eacute;neration de contenu &agrave; la vol&eacute;e</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Nous voulons g&eacute;n&eacute;rer du contenu de mani&egrave;re dynamique, mais le
      conserver de mani&egrave;re statique lorsqu'il a &eacute;t&eacute; g&eacute;n&eacute;r&eacute;. La r&egrave;gle
      suivante v&eacute;rifie l'existence du fichier statique, et le g&eacute;n&egrave;re
      s'il est absent. Les fichiers statiques peuvent &ecirc;tre supprim&eacute;s
      p&eacute;riodiquement si on le d&eacute;sire (par exemple via cron), et seront
      r&eacute;g&eacute;n&eacute;r&eacute;s &agrave; la demande.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      A cet effet, on utilise le jeu de r&egrave;gles suivant :

<highlight language="config">
# Cet exemple n'est valable que dans un contexte de r&eacute;pertoire
RewriteCond %{REQUEST_URI}   !-U
RewriteRule ^(.+)\.html$          /regenerate_page.cgi   [PT,L]
</highlight>

      <p>L'op&eacute;rateur <code>-U</code> permet de d&eacute;terminer si la cha&icirc;ne
      de test (dans ce cas <code>REQUEST_URI</code>) est une URL valide.
      Pour ce faire, il utilise une sous-requ&ecirc;te. Si cette sous-requ&ecirc;te
      &eacute;choue, ou en d'autres termes, si la ressource demand&eacute;e n'existe pas,
      cette r&egrave;gle invoque le programme CGI
      <code>/regenerate_page.cgi</code> qui g&eacute;n&egrave;re la ressource
      demand&eacute;e et la sauvegarde dans le r&eacute;pertoire des documents, de
      fa&ccedil;on &agrave; ce qu'une copie statique puisse &ecirc;tre servie lors d'une
      demande ult&eacute;rieure.</p>

    <p>De cette fa&ccedil;on, les documents qui ne sont pas mis &agrave; jour
    r&eacute;guli&egrave;rement peuvent &ecirc;tre servis sous une forme statique. Si ces
    documents doivent &ecirc;tre r&eacute;actualis&eacute;s, on peut les supprimer du
    r&eacute;pertoire des documents, et ils seront ainsi r&eacute;g&eacute;n&eacute;r&eacute;s &agrave; la
    prochaine demande.</p>
    </dd>
  </dl>

</section>

<section id="load-balancing">

  <title>R&eacute;partition de charge</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Nous voulons r&eacute;partir la charge de mani&egrave;re al&eacute;atoire entre
      plusieurs serveurs en utilisant mod_rewrite.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>Pour y parvenir, nous allons utiliser la directive <directive
      module="mod_rewrite">RewriteMap</directive> et une liste de
      serveurs.</p>

<highlight language="config">
RewriteEngine on
RewriteMap lb rnd:/path/to/serverlist.txt
RewriteRule ^/(.*) http://${lb:serveurs}/$1 [P,L]
</highlight>

<p><code>liste-serveurs.txt</code> contiendra la liste des serveurs :</p>

<example>
## liste-serveurs.txt<br />
<br />
serveurs un.example.com|deux.example.com|trois.example.com<br />
</example>

<p>Si vous voulez qu'un serveur se voit confier d'avantage de charge que
les autres, faites le figurer plusieurs fois dans la liste.</p>

   </dd>

   <dt>Discussion</dt>
   <dd>
<p>Apache poss&egrave;de un module de r&eacute;partition de charge -
<module>mod_proxy_balancer</module> - beaucoup plus souple et pr&eacute;sentant
plus de fonctionnalit&eacute;s dans ce domaine que mod_rewrite.</p>
   </dd>
  </dl>

</section>

<section id="autorefresh">

  <title>Actualisation automatique d'un document</title>

  <!--
+I'm trying to decide whether this example is worthwhile to keep, and, if
+so, whether it needs to be updated/rewritten. Certainly the description
+needs to be rewritten. I'm not sure we really need to be recommending
+nph-refresh techniques.
+-->

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Lorsque nous cr&eacute;ons une page web complexe, ne serait-il pas
	  souhaitable que le navigateur web actualise automatiquement la
	  page chaque fois que nous en sauvegardons une nouvelle version
	  &agrave; partir de notre &eacute;diteur ? Impossible ?</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>Non ! Nous allons pour cela combiner la fonctionnalit&eacute; MIME
	  multipart, la fonctionnalit&eacute; NPH du serveur web et la
	  puissance de <module>mod_rewrite</module> pour la manipulation
	  d'URLs. Tout d'abord, nous d&eacute;finissons une nouvelle
	  fonctionnalit&eacute; pour les URLs : l'ajout de
	  <code>:refresh</code> &agrave; toute URL fait que la 'page' est
	  actualis&eacute;e chaque fois que la ressource est mise &agrave; jour dans
	  le syst&egrave;me de fichiers.</p>

<highlight language="config">
RewriteRule   ^(/[uge]/[^/]+/?.*):refresh  /interne/cgi/apache/nph-refresh?f=$
</highlight>

      <p>Nous appelons maintenant cette URL</p>

<example>
/u/foo/bar/page.html:refresh
</example>

      <p>ce qui entra&icirc;ne en interne l'invocation de l'URL</p>

<example>
/interne/cgi/apache/nph-refresh?f=/u/foo/bar/page.html
</example>

      <p>Il ne reste plus qu'&agrave; &eacute;crire le script NPH-CGI. Bien que l'on
	  &eacute;crive habituellement dans ces cas "laiss&eacute; &agrave; la charge du
	  lecteur &agrave; titre d'exercice", ;-) je vous l'offre, aussi.</p>

<highlight language="perl">
#!/sw/bin/perl
##
##  nph-refresh -- script NPH/CGI pour l'actualisation automatique de
##  pages
##  Copyright (c) 1997 Ralf S. Engelschall, All Rights Reserved.
##
$| = 1;

#   &eacute;clate la variable QUERY_STRING
@pairs = split( /&amp;/, $ENV{'QUERY_STRING'} );
foreach $pair (@pairs) {
    ( $name, $value ) = split( /=/, $pair );
    $name =~ tr/A-Z/a-z/;
    $name = 'QS_' . $name;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    eval "\$$name = \"$value\"";
}
$QS_s = 1    if ( $QS_s eq '' );
$QS_n = 3600 if ( $QS_n eq '' );
if ( $QS_f eq '' ) {
    print "HTTP/1.0 200 OK\n";
    print "Content-type: text/html\n\n";
    print "&lt;b&gt;ERROR&lt;/b&gt;: No file given\n";
    exit(0);
}
if ( !-f $QS_f ) {
    print "HTTP/1.0 200 OK\n";
    print "Content-type: text/html\n\n";
    print "&lt;b&gt;ERROR&lt;/b&gt;: File $QS_f not found\n";
    exit(0);
}

sub print_http_headers_multipart_begin {
    print "HTTP/1.0 200 OK\n";
    $bound = "ThisRandomString12345";
    print "Content-type: multipart/x-mixed-replace;boundary=$bound\n";
    &amp;print_http_headers_multipart_next;
}

sub print_http_headers_multipart_next {
    print "\n--$bound\n";
}

sub print_http_headers_multipart_end {
    print "\n--$bound--\n";
}

sub displayhtml {
    local ($buffer) = @_;
    $len = length($buffer);
    print "Content-type: text/html\n";
    print "Content-length: $len\n\n";
    print $buffer;
}

sub readfile {
    local ($file) = @_;
    local ( *FP, $size, $buffer, $bytes );
    ( $x, $x, $x, $x, $x, $x, $x, $size ) = stat($file);
    $size = sprintf( "%d", $size );
    open( FP, "&lt;$file" );
    $bytes = sysread( FP, $buffer, $size );
    close(FP);
    return $buffer;
}

$buffer = &amp;readfile($QS_f);
&amp;print_http_headers_multipart_begin;
&amp;displayhtml($buffer);

sub mystat {
    local ($file) = $_[0];
    local ($time);

    ( $x, $x, $x, $x, $x, $x, $x, $x, $x, $mtime ) = stat($file);
    return $mtime;
}

$mtimeL = &amp;mystat($QS_f);
$mtime  = $mtime;
for ( $n = 0 ; $n &amp; lt ; $QS_n ; $n++ ) {
    while (1) {
        $mtime = &amp;mystat($QS_f);
        if ( $mtime ne $mtimeL ) {
            $mtimeL = $mtime;
            sleep(2);
            $buffer = &amp;readfile($QS_f);
            &amp;print_http_headers_multipart_next;
            &amp;displayhtml($buffer);
            sleep(5);
            $mtimeL = &amp;mystat($QS_f);
            last;
        }
        sleep($QS_s);
    }
}

&amp;print_http_headers_multipart_end;

exit(0);

##EOF##
</highlight>
    </dd>
  </dl>

</section>

<section id="structuredhomedirs">

  <title>R&eacute;pertoires Home structur&eacute;s</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Certains sites avec des milliers d'utilisateurs organisent
	  les r&eacute;pertoires utilisateurs de mani&egrave;re structur&eacute;e, c'est &agrave;
	  dire que chaque r&eacute;pertoire utilisateur se trouve dans un
	  sous-r&eacute;pertoire dont le nom commence (par exemple) par le
	  premier caract&egrave;re du nom de l'utilisateur. Ainsi,
	  <code>/~larry/chemin</code> correspond &agrave;
	  <code>/home/<strong>l</strong>/larry/public_html/chemin</code>, alors
	  que <code>/~waldo/chemin</code> correspond &agrave;
	  <code>/home/<strong>w</strong>/waldo/public_html/chemin</code>.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>On utilise le jeu de r&egrave;gles suivant pour d&eacute;velopper les
	  URLs avec tilde selon l'organisation structur&eacute;e pr&eacute;c&eacute;dente.</p>

<highlight language="config">
RewriteEngine on
RewriteRule   ^/~(<strong>([a-z])</strong>[a-z0-9]+)(.*)  /home/<strong>$2</strong>/$1/public_html$3
</highlight>
    </dd>
  </dl>

</section>

<section id="redirectanchors">

  <title>Redirection des ancrages</title>

  <dl>
    <dt>Description :</dt>

    <dd>
    <p>Par d&eacute;faut, la redirection vers un ancrage HTML ne fonctionne
	pas, car mod_rewrite &eacute;chappe le caract&egrave;re <code>#</code> en le
	transformant en <code>%23</code>, ce qui rend la redirection
	inop&eacute;rante.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>On utilise le drapeau <code>[NE]</code> dans la r&egrave;gle
	  <code>RewriteRule</code>. NE signifie "No Escape".
      </p>
    </dd>

    <dt>Discussion :</dt>
    <dd>Cette technique fonctionne bien entendu pour tout autre
    caract&egrave;re sp&eacute;cial que mod_rewrite, par d&eacute;faut, code pour insertion
    dans une URL.</dd>
  </dl>

</section>

<section id="time-dependent">

  <title>R&eacute;&eacute;criture d&eacute;pendant de l'heure</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Nous voulons servir des contenus diff&eacute;rents selon l'heure du
      jour en utilisant mod_rewrite.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>Il existe de nombreuses variables nomm&eacute;es
	  <code>TIME_xxx</code> utilisables dans les conditions de
	  r&eacute;&eacute;criture. Utilis&eacute;es en conjonction avec les mod&egrave;les de
	  comparaison lexicographique sp&eacute;ciaux <code>&lt;STRING</code>,
	  <code>&gt;STRING</code> et <code>=STRING</code>, elles
	  permettent d'effectuer des redirections d&eacute;pendant de
	  l'heure :</p>

<highlight language="config">
+RewriteEngine on
+RewriteCond   %{TIME_HOUR}%{TIME_MIN} &gt;0700
+RewriteCond   %{TIME_HOUR}%{TIME_MIN} &lt;1900
+RewriteRule   ^foo\.html$             foo.day.html [L]
</highlight>

      <p>Avec cet exemple, l'URL <code>foo.html</code> renvoie
	  le contenu de <code>foo.jour.html</code> durant le
	  cr&eacute;neau horaire <code>07:01-18:59</code>, et le contenu de
	  <code>foo.nuit.html</code> le reste du temps.</p>

      <note type="warning"><module>mod_cache</module>, les mandataires
	interm&eacute;diaires et les navigateurs peuvent chacun mettre en cache
	les r&eacute;ponses et ainsi afficher une des deux pages en dehors de
	la fen&ecirc;tre de temps configur&eacute;e. On peut utiliser
	<module>mod_expires</module> pour contourner ce probl&egrave;me. Il est
	cependant bien plus commode de servir un contenu dynamique, et
	de le personnaliser en fonction de l'heure du jour.</note>
    </dd>
  </dl>

</section>

<section id="setenvvars">

  <title>D&eacute;finir des variables d'environnement en fonction de
      certaines parties de l'URL</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Ici, nous voulons conserver une certaine forme de statut
      lorsqu'une r&eacute;&eacute;criture a eu lieu. Par exemple, vous souhaitez
      consigner le fait que cette r&eacute;&eacute;criture a eu lieu, et vous servir
      plus tard de cette information pour d&eacute;terminer si une requ&ecirc;te sera
      concern&eacute;e par cette r&eacute;&eacute;criture. Pour y parvenir, on peut utiliser
      une variable d'environnement.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>Utiliser le drapeau [E] pour d&eacute;finir une variable
      d'environnement.</p>

<highlight language="config">
RewriteEngine on
RewriteRule   ^/cheval/(.*)   /poney/$1 [E=<strong>rewritten:1</strong>]
</highlight>

    <p>Plus loin dans votre jeu de r&egrave;gles, vous pouvez v&eacute;rifier le
    contenu de cette variable d'environnement via une directive
    RewriteCond :</p>

<highlight language="config">
RewriteCond %{ENV:rewritten} =1
</highlight>

    </dd>
  </dl>

</section>

</manualpage>
