/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.List;

public final class CheckUtils {
    private static final int BASE_8 = 8;
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;

    private CheckUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isEqualsMethod(DetailAST aAST) {
        if (aAST.getType() != 9) {
            return false;
        }
        DetailAST modifiers = aAST.findFirstToken(5);
        if (modifiers.branchContains(64) || modifiers.branchContains(40)) {
            return false;
        }
        DetailAST nameNode = aAST.findFirstToken(58);
        String name = nameNode.getText();
        if (!"equals".equals(name)) {
            return false;
        }
        DetailAST paramsNode = aAST.findFirstToken(20);
        return paramsNode.getChildCount() == 1;
    }

    public static boolean isElseIf(DetailAST aAST) {
        DetailAST parentAST = aAST.getParent();
        return aAST.getType() == 83 && (CheckUtils.isElse(parentAST) || CheckUtils.isElseWithCurlyBraces(parentAST));
    }

    private static boolean isElse(DetailAST aAST) {
        return aAST.getType() == 92;
    }

    private static boolean isElseWithCurlyBraces(DetailAST aAST) {
        return aAST.getType() == 7 && aAST.getChildCount() == 2 && CheckUtils.isElse(aAST.getParent());
    }

    public static FullIdent createFullType(DetailAST aTypeAST) {
        DetailAST arrayDeclAST = aTypeAST.findFirstToken(17);
        return CheckUtils.createFullTypeNoArrays(arrayDeclAST == null ? aTypeAST : arrayDeclAST);
    }

    private static FullIdent createFullTypeNoArrays(DetailAST aTypeAST) {
        return FullIdent.createFullIdent((DetailAST)aTypeAST.getFirstChild());
    }

    public static double parseDouble(String aText, int aType) {
        double result = 0.0;
        switch (aType) {
            case 140: 
            case 142: {
                result = Double.parseDouble(aText);
                break;
            }
            case 137: 
            case 141: {
                int radix = 10;
                if (aText.startsWith("0x") || aText.startsWith("0X")) {
                    radix = 16;
                    aText = aText.substring(2);
                } else if (aText.charAt(0) == '0') {
                    radix = 8;
                    aText = aText.substring(1);
                }
                if (aText.endsWith("L") || aText.endsWith("l")) {
                    aText = aText.substring(0, aText.length() - 1);
                }
                if (aText.length() <= 0) break;
                if (aType == 137) {
                    result = CheckUtils.parseInt(aText, radix);
                    break;
                }
                result = CheckUtils.parseLong(aText, radix);
                break;
            }
        }
        return result;
    }

    public static int parseInt(String aText, int aRadix) {
        int result = 0;
        int max = aText.length();
        for (int i = 0; i < max; ++i) {
            int digit = Character.digit(aText.charAt(i), aRadix);
            result *= aRadix;
            result += digit;
        }
        return result;
    }

    public static long parseLong(String aText, int aRadix) {
        long result = 0L;
        int max = aText.length();
        for (int i = 0; i < max; ++i) {
            int digit = Character.digit(aText.charAt(i), aRadix);
            result *= (long)aRadix;
            result += (long)digit;
        }
        return result;
    }

    public static double parseFloat(String aText, int aType) {
        return (float)CheckUtils.parseDouble(aText, aType);
    }

    public static DetailAST getFirstNode(DetailAST aNode) {
        DetailAST currentNode = aNode;
        for (DetailAST child = (DetailAST)aNode.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
            DetailAST newNode = CheckUtils.getFirstNode(child);
            if (newNode.getLineNo() >= currentNode.getLineNo() && (newNode.getLineNo() != currentNode.getLineNo() || newNode.getColumnNo() >= currentNode.getColumnNo())) continue;
            currentNode = newNode;
        }
        return currentNode;
    }

    public static List getTypeParameterNames(DetailAST aNode) {
        DetailAST typeParameters = aNode.findFirstToken(165);
        ArrayList<String> typeParamNames = new ArrayList<String>();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParamNames.add(typeParam.findFirstToken(58).getText());
            for (DetailAST sibling = (DetailAST)typeParam.getNextSibling(); sibling != null; sibling = (DetailAST)sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParamNames.add(sibling.findFirstToken(58).getText());
            }
        }
        return typeParamNames;
    }

    public static List getTypeParameters(DetailAST aNode) {
        DetailAST typeParameters = aNode.findFirstToken(165);
        ArrayList<DetailAST> typeParams = new ArrayList<DetailAST>();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParams.add(typeParam);
            for (DetailAST sibling = (DetailAST)typeParam.getNextSibling(); sibling != null; sibling = (DetailAST)sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParams.add(sibling);
            }
        }
        return typeParams;
    }
}

