/*
 * Decompiled with CFR 0.152.
 */
package org.epistem.io;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import org.epistem.util.Hex;

public class Byte4ByteDebugStreams
extends OutputStream {
    protected ByteArrayInputStream in;
    protected byte[] bytesIn;
    protected byte[] bytesOut;
    protected int bytePtr = 0;
    public boolean dumpOnError = false;

    public Byte4ByteDebugStreams(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        this.bytesIn = new byte[(int)randomAccessFile.length()];
        this.bytesOut = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(this.bytesIn);
        randomAccessFile.close();
    }

    public Byte4ByteDebugStreams(byte[] byArray) {
        this.bytesIn = byArray;
        this.bytesOut = new byte[byArray.length];
    }

    public InputStream getInputStream() {
        if (this.in != null) {
            return this.in;
        }
        this.in = new ByteArrayInputStream(this.bytesIn);
        return this.in;
    }

    public void setInputBytes(byte[] byArray) {
        this.bytesIn = byArray;
    }

    public void write(int n) throws IOException {
        if (n > 127) {
            n = (n & 0x7F) - 128;
        }
        this.bytesOut[this.bytePtr] = (byte)n;
        if (this.bytesOut[this.bytePtr] != this.bytesIn[this.bytePtr]) {
            IOException iOException = new IOException("Byte mismatch between input and output at byte #" + this.bytePtr + " 0x" + Integer.toHexString(this.bytePtr) + "\nexpected 0x" + Integer.toHexString(this.bytesIn[this.bytePtr]) + " but got 0x" + Integer.toHexString(n));
            iOException.printStackTrace();
            if (this.dumpOnError) {
                System.err.println("---- INPUT DATA ----");
                Hex.dump(new PrintWriter(System.err), this.bytesIn, 0, this.bytePtr + 1, 0L, "  ", false);
                System.err.println("---- OUTPUT DATA ----");
                Hex.dump(new PrintWriter(System.err), this.bytesOut, 0, this.bytePtr + 1, 0L, "  ", false);
            }
            throw iOException;
        }
        ++this.bytePtr;
    }

    public void write(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.bytesOut);
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

