package org.richfaces.cdk.rd;

import java.io.File;
import java.io.FilenameFilter;


/**
 * @author Anton Belevich
 *
 */
public class RichWebSourceWalker {
	
	
	private FilenameFilter filter;
	
	private ComponentsScanner scanner;
	
	public RichWebSourceWalker(ComponentsScanner scanner) {
		this(scanner, new FilenameFilter () {
			public boolean accept(File dir, String name) {
				return true;
			}
		}) ;
	}
	
	public RichWebSourceWalker(ComponentsScanner scanner, FilenameFilter filter) {
		this.filter = filter;
		this.scanner = scanner;
	}
	
	public void walk(File file) throws Exception{
		if(file.isDirectory()) {
			String[] children = file.list();
	        for (String child : children) {
	        	walk((new File(file, child)));
	        }
		} else {
			if(filter.accept(file, file.getName())) {
				System.out.println("Process File: " + file.getName());
				scanner.doScan(file);
			}	
		}	
	}

	public FilenameFilter getFilter() {
		return filter;
	}

	public void setFilter(FilenameFilter filter) {
		this.filter = filter;
	}
}
