package org.richfaces.realworld.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.validator.Length;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.NotNull;
import org.jboss.seam.annotations.Name;

@Entity
@Name("gallery")
@Table(name = "galleries")
public class Gallery implements Serializable {

    private static final long serialVersionUID = -7042878411608396483L;

    @Id
    @GeneratedValue
    @Column(name = "GALLERY_ID")
    private Long id = null;

    @Column(length = 255, nullable = false)
    @NotNull
	@NotEmpty
    @Length(min=3)
    private String name;
    
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "gallery")
    @org.hibernate.annotations.OrderBy(clause = "uploaded desc")
    @org.hibernate.annotations.Fetch(org.hibernate.annotations.FetchMode.SUBSELECT)
    private List<GalleryImage> images = new ArrayList<GalleryImage>();
    
    /**
	 * Getter for property id
	 * 
	 * @return id of album
	 */
    public Long getId() {
        return id;
    }

    /**
	 * Getter for property name
	 * 
	 * @return name of album
	 */
    public String getName() {
        return name;
    }

	/**
	 * Setter for property name
	 * 
	 * @param name - name of album
	 */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
	 * This method add image to collection of images of current album
	 * 
	 * @param image - image to add
	 */
    public void addImage(GalleryImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Null image!");
        } 
        if (image.getGallery() != null && !this.equals(image.getGallery())) {
            image.getGallery().getImages().remove(image);
        }   
        image.setGallery(this);
        images.add(image);
    }

	/**
	 * This method remove image from collection of images of album
	 * 
	 * @param image - image to remove
	 */
    public void removeImage(GalleryImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Null image");
        }  
        image.setGallery(null);
        images.remove(image);
    }

	/**
	 * This method return count of images of current album
	 * 
	 * @return count of images of this album
	 */
    public int getCountImages() {
        return this.getImages()!= null ? this.getImages().size() : 0;

    }
    
    public List<GalleryImage> getImages() {
		return images;
	}

}
