package org.richfaces.realworld.service;

import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.richfaces.realworld.domain.Gallery;
import org.richfaces.realworld.domain.GalleryImage;

@Name("galleryAction")
@Stateless
public class GalleryAction implements IGalleryAction {

	@In(value="entityManager")
	EntityManager em;
	/* (non-Javadoc)
	 * @see org.richfaces.realworld.service.IGalleryAction#addGallery(java.lang.String)
	 */
	public void addGallery(String name){
		Gallery gal = new Gallery();
		gal.setName(name);
		em.persist(gal);
		em.flush();
	}
	
	/* (non-Javadoc)
	 * @see org.richfaces.realworld.service.IGalleryAction#addmage(org.richfaces.realworld.domain.Gallery, org.richfaces.realworld.domain.GalleryImage)
	 */
	public void addImage(Gallery gallery, GalleryImage image){
		gallery.addImage(image);
		em.flush();
	}
	
	/* (non-Javadoc)
	 * @see org.richfaces.realworld.service.IGalleryAction#getGalleries()
	 */
	public List<Gallery> getGalleries(){
		List<Gallery> galleries = em.createQuery("from Gallery")
		.getResultList();
		return galleries;
	}
}
