package org.richfaces.realworld.service;

import java.util.List;

import javax.ejb.Local;

import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.FriendshipRequest;
import org.richfaces.realworld.domain.User;

@Local
public interface IUserAction {
	public User login(String username, String password);
	public void register(User user);
	public boolean isUserExist(String login);
	public void updateUser(User user);
	public void resetUser(User user);
	public List<String> getUsers(String suggest);
	public long countNotReadedMessages(User user);
	public void removeFromFriends(User owner, User removed);
	public boolean friendExist(User user, User friend);
	public void addFriend(User user, User friend, FriendshipRequest request);
	public void removeFromSharedAlbums(User user, Album album);
	public void addSharedAlbum(Album album);
	public void loginAnonymous();
}