/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.navigation;

import java.io.Serializable;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

@Name(value="navigationHelper")
@Scope(ScopeType.CONVERSATION)
public class NavigationHelper implements Serializable{

	private static final long serialVersionUID = -89683694316344212L;
	
	private NavigationEnum navigationEnum;
	
	public NavigationEnum getNavigationEnumUserPrefs(){
		return NavigationEnum.USER_PREFS;
	}
	
	public NavigationEnum getNavigationEnumGallery(){
		return NavigationEnum.GALLERY;
	}
	
	public NavigationEnum getNavigationEnumSearch(){
		return NavigationEnum.SEARCH;
	}
	
	public NavigationEnum getNavigationEnumReadMessages(){
		return NavigationEnum.READ_MESSAGES;
	}
	
	public NavigationEnum getNavigationEnumImagePreview(){
		return NavigationEnum.IMAGE_PREVIEW;
	}
	
	public NavigationEnum getNavigationEnumFileUpload(){
		return NavigationEnum.FILE_UPLOAD;
	}
}
