/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.util;

import java.io.Serializable;
import java.util.ArrayList;

import javax.faces.event.ActionEvent;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.Image;
import org.richfaces.realworld.domain.MetaTag;
import org.richfaces.realworld.manager.AlbumManager;
import org.richfaces.realworld.manager.ImageManager;

@Name("confirmationPopupHelper")
@Scope(ScopeType.CONVERSATION)
public class ConfirmationPopupHelper implements Serializable{

	private static final long serialVersionUID = 2561824019376412988L;
	
	private String caption;
	
	private String actionName;
	
	@In(create=true, required=true)
	private Image image;
	
	@In(create=true, required=true)
	private Album album;
	
	@In(create=true, required=true)
	private AlbumManager albumManager;
	
	@In(create=true, required=true)
	private ImageManager imageManager;
	
	public void initImagePopup( String actionName, String caption, Image image){
		this.caption = caption;
		this.actionName = actionName;
		if(null != image){
			this.image = image;
			image.setMeta(new ArrayList<MetaTag>(image.getTags()));
		}else{
			this.image = new Image();
		}
	}
	
	public void initAlbumData( String actionName, String caption, Album album){
		this.caption = caption;
		this.actionName = actionName;
		if(null != album){
			this.album = album;
		}else{
			this.album = new Album();
		}
	}
	
	public void deleteAlbum(ActionEvent event){
		albumManager.deleteAlbum(this.album);
	}
	
	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getActionName() {
		return actionName;
	}

	public void setActionName(String actionName) {
		this.actionName = actionName;
	}
	
	public void deleteImage(ActionEvent event){
		imageManager.deleteImage(this.image);
	}
	
}
