/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.ajax4jsf.bean;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.ajax4jsf.component.UIRepeat;

/**
 * a4j:repeat component test bean
 * @author Alexandr Levkovsky
 *
 */
public class A4JRepeatTestBean {

    private Integer first = 0;

    private Integer rows = 5;
    
    private Integer visible = 0;

    private List<A4JRepeatItemTestBean> items;

    private UIRepeat repeater;

    private Boolean rendered = true;
    
    private Set<Integer> keys = null;

    /**
     * @return the first
     */
    public Integer getFirst() {
	return first;
    }

    /**
     * @param first the first to set
     */
    public void setFirst(Integer first) {
	this.first = first;
    }

    /**
     * @return the rows
     */
    public Integer getRows() {
	return rows;
    }

    /**
     * @param rows the rows to set
     */
    public void setRows(Integer rows) {
	this.rows = rows;
    }

    /**
     * @return the items
     */
    public List<A4JRepeatItemTestBean> getItems() {
	if (items == null) {
	    generateItems(getRows());
	}
	return items;
    }

    /**
     * @param items the items to set
     */
    public void setItems(List<A4JRepeatItemTestBean> items) {
	this.items = items;
    }

    /**
     * @return the repeater
     */
    public UIRepeat getRepeater() {
	return repeater;
    }

    /**
     * @param repeater the repeater to set
     */
    public void setRepeater(UIRepeat repeater) {
	this.repeater = repeater;
    }

    /**
     * @return the rendered
     */
    public Boolean getRendered() {
	return rendered;
    }

    /**
     * @param rendered the rendered to set
     */
    public void setRendered(Boolean rendered) {
	this.rendered = rendered;
    }
    
    
    
    /**
     * @return the visible
     */
    public Integer getVisible() {
        return visible;
    }

    /**
     * @param visible the visible to set
     */
    public void setVisible(Integer visible) {
        this.visible = visible;
    }

    private void generateItems(Integer rows) {
	items = new ArrayList<A4JRepeatItemTestBean>(rows);
	for (int i = 0; i < rows; i++) {
	    A4JRepeatItemTestBean item = new A4JRepeatItemTestBean(i);
	    items.add(item);

	}
    }
    
    public String init(){
	generateItems(getRows());
	return null;
    }
    
    public String reset(){
	setRows(5);
	setRendered(true);
	setVisible(0);
	setFirst(0);
	generateItems(getRows());
	return null;
    }

    /**
     * @return the keys
     */
    public Set<Integer> getKeys() {
        return keys;
    }

    /**
     * @param keys the keys to set
     */
    public void setKeys(Set<Integer> keys) {
        this.keys = keys;
    }
    
    public String change() {
	Set<Integer> keys = new HashSet<Integer>();
	int rowKey = getRepeater().getRowIndex();
	keys.add(rowKey);
	setKeys(keys);
	for (A4JRepeatItemTestBean item : items) {
	    item.setNotRerenderedChangeCounter(item.getNotRerenderedChangeCounter() + 1);
	    item.setRerenderedChangeCounter(item.getRerenderedChangeCounter() + 1);
	}
	return null;
    }

    public String changeWhithoutAjaxKeys() {
	setKeys(null);
	for (A4JRepeatItemTestBean item : items) {
	    item.setNotRerenderedChangeCounter(item.getNotRerenderedChangeCounter() + 1);
	    item.setRerenderedChangeCounter(item.getRerenderedChangeCounter() + 1);
	}
	return null;
    }

}
