/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.ajax4jsf.bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.event.ActionEvent;

import org.richfaces.component.UIDatascroller;

/**
 * Bean class for dataScroller component testing
 * @author Andrey Markavtsov
 *
 */
@SuppressWarnings("unchecked")
public class DataScrollerBean {
	
	
	private List data;
	
	private Integer tableRows = 1;
	
	private Integer totalRows = 10;
	
	private Integer maxPages = 10;
	
	private Integer page;
	
	private String onpagechange = "EventQueue.fire('onpagechange')";
	
	private String reRender;
	
	private boolean renderIfSinglePage = true;
	
	private UIDatascroller scroller;
	
	public DataScrollerBean() {
		init();
	}
	
	public String maxPages() {
		maxPages = 5;
		return null;
	}
	
	public String onpagechange() {
		onpagechange = "return false;";
		return null;
	}
	
	public String pageVars() {
		reRender = "activePage, pagesCount";
		return null;
	}
	
	
	private void init() {
		data = new ArrayList();
		for (int i = 0; i < totalRows; i++) {
			String content = "Page " + (i / tableRows + 1);
			data.add(new Object [] {i + 1, content});
		}
	}
	
	public void reset() {
		tableRows = 1;
		totalRows = 10;
		maxPages = 10;
		page = null;
		data = null;
		onpagechange = "EventQueue.fire('onpagechange')";
		renderIfSinglePage = true;
	}
	
	public void apply(ActionEvent event) {
		init();
	}
	
	public String getTime() {
		return String.valueOf(new Date().getTime());
	}
	
	public String changeRenderIfSinglePage() {
		if(renderIfSinglePage){
			renderIfSinglePage = false;
		}else{
			renderIfSinglePage = true;
		}
		return null;
	}
	
	public String changePage() {
		page = 5;
		return null;
	}

	/**
	 * @return the data
	 */
	public List getData() {
		if (data == null) {
			init();
		}
		return data;
	}

	/**
	 * @param data the data to set
	 */
	public void setData(List data) {
		this.data = data;
	}

	/**
	 * @return the tableRows
	 */
	public Integer getTableRows() {
		return tableRows;
	}

	/**
	 * @param tableRows the tableRows to set
	 */
	public void setTableRows(Integer tableRows) {
		this.tableRows = tableRows;
	}

	/**
	 * @return the totalRows
	 */
	public Integer getTotalRows() {
		return totalRows;
	}

	/**
	 * @param totalRows the totalRows to set
	 */
	public void setTotalRows(Integer totalRows) {
		this.totalRows = totalRows;
	}

	/**
	 * @return the maxPages
	 */
	public Integer getMaxPages() {
		return maxPages;
	}

	/**
	 * @param maxPages the maxPages to set
	 */
	public void setMaxPages(Integer maxPages) {
		this.maxPages = maxPages;
	}

	/**
	 * @return the page
	 */
	public Integer getPage() {
		return page;
	}

	/**
	 * @param page the page to set
	 */
	public void setPage(Integer page) {
		this.page = page;
	}

	/**
	 * @return the onpagechange
	 */
	public String getOnpagechange() {
		return onpagechange;
	}

	/**
	 * @param onpagechange the onpagechange to set
	 */
	public void setOnpagechange(String onpagechange) {
		this.onpagechange = onpagechange;
	}

	/**
	 * @return the reRender
	 */
	public String getReRender() {
		return reRender;
	}

	/**
	 * @param reRender the reRender to set
	 */
	public void setReRender(String reRender) {
		this.reRender = reRender;
	}

	/**
	 * @return the renderIfSinglePage
	 */
	public boolean isRenderIfSinglePage() {
		return renderIfSinglePage;
	}

	/**
	 * @param renderIfSinglePage the renderIfSinglePage to set
	 */
	public void setRenderIfSinglePage(boolean renderIfSinglePage) {
		this.renderIfSinglePage = renderIfSinglePage;
	}

	/**
	 * @return the scroller
	 */
	public UIDatascroller getScroller() {
		return scroller;
	}

	/**
	 * @param scroller the scroller to set
	 */
	public void setScroller(UIDatascroller scroller) {
		this.scroller = scroller;
	}

	
}
