/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.annotations.Test;

public class DataFilterSliderTest extends SeleniumTestBase {

    private static final String DATA_FLT_SLIDER_ID = "dataFilterSlider";

    private static final String DATA_FLT_SLIDER_INPUT = DATA_FLT_SLIDER_ID + "slider_val";

    private static final String DATA_FLT_SLIDER_TRACK = DATA_FLT_SLIDER_ID + "slider-track";

    private static final String TABLE = "planetList";

    private static final int PLANETS_ALL = 11;

    private static final int PLANETS_SMALLER_3 = 10;

    private static final int PLANETS_SMALLER_2 = 9;

    private static final int PLANETS_SMALLER_1 = 6;

    @Test
    public void testDataFilterSliderComponent(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";
        String tableId = parentId + TABLE;

        writeStatus("Check component core functionality");

        writeStatus("In the beginning all planets have to be displayed");
        assertColumnsCount(2, tableId);
        assertRowsCount(PLANETS_ALL, tableId);

        writeStatus("Set 1g! Only 6 planets have to meet this condition");
        clickSlider(1);
        assertRowsCount(PLANETS_SMALLER_1, tableId);

        writeStatus("Set 2g! Only 9 planets have to meet this condition");
        clickSlider(2);
        assertRowsCount(PLANETS_SMALLER_2, tableId);

        writeStatus("Set 5g! Only 10 planets have to meet this condition");
        clickSlider(5);
        assertRowsCount(PLANETS_SMALLER_3, tableId);

    }

    @Test
    public void testDataFilterSliderComponentManualInput(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";
        String tableId = parentId + TABLE;
        String inputId = parentId + DATA_FLT_SLIDER_INPUT;

        writeStatus("Check component manual input");

        writeStatus("In the beginning all planets have to be displayed");
        assertColumnsCount(2, tableId);
        assertRowsCount(PLANETS_ALL, tableId);

        writeStatus("Type 1g! Only 6 planets have to meet this condition");
        selenium.type(inputId, "1");
        waitForAjaxCompletion();
        assertRowsCount(PLANETS_SMALLER_1, tableId);

        writeStatus("Type 2g! Only 9 planets have to meet this condition");
        selenium.type(inputId, "2");
        waitForAjaxCompletion();
        assertRowsCount(PLANETS_SMALLER_2, tableId);

        writeStatus("Type 5g! Only 10 planets have to meet this condition");
        selenium.type(inputId, "5");
        waitForAjaxCompletion();
        assertRowsCount(PLANETS_SMALLER_3, tableId);
    }

    private void clickSlider(int position) {
        String trackId = getParentId() + "_form:" + DATA_FLT_SLIDER_TRACK;
        int w = selenium.getElementWidth(trackId).intValue();
        double step = w / 40.;
        int pos = (int) (position * step + 1 + (isFF() ? step : 0));
        selenium.mouseDownAt(trackId, pos + ",0");
        selenium.mouseUpAt(trackId, pos + ",0");
        waitForAjaxCompletion();
        delay(500);
    }

    @Override
    public String getTestUrl() {
        return "pages/dataFilterSlider/dataFilterSliderTest.xhtml";
    }

}
