package org.epistem.jsp;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;
import javax.servlet.jsp.PageContext;

import org.epistem.servlet.BaseServlet;

/**
 * Utility base for JSPs.
 *
 * @author nick
 */
public abstract class BaseJSP 
    extends    BaseServlet  
    implements HttpJspPage 
{
    protected PageContext pageContext;

    protected BaseJSP()	{
		//nada
    }

	/**
	 *  @see javax.servlet.Servlet#init(javax.servlet.ServletConfig)
	 */
    public final void init( ServletConfig config ) throws ServletException {
        super.init( config );
		jspInit();
    }
    
	/**
	 *  @see javax.servlet.Servlet#getServletInfo()
	 */
    public String getServletInfo() {
		return "Base JSP";
    }

	/**
	 *  @see javax.servlet.Servlet#destroy()
	 */
    public final void destroy() {
		jspDestroy();
    }

	/**
	 *  @see javax.servlet.http.HttpServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
    public abstract void service( HttpServletRequest request, HttpServletResponse response ) 
		throws ServletException, IOException;
    
	/**
	 *  @see javax.servlet.jsp.JspPage#jspInit()
	 */
    public void jspInit() {
		//nada
    }	
    
	/**
	 *  @see javax.servlet.jsp.JspPage#jspDestroy()
	 */
    public void jspDestroy() {
		//nada
    }
	
	/**
	 *  @see javax.servlet.jsp.HttpJspPage#_jspService(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
    public abstract void _jspService( HttpServletRequest request, HttpServletResponse response ) 
		throws ServletException, IOException;
}
